/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.AbstractCondition;
import com.conversantmedia.util.concurrent.AbstractSpinningCondition;
import com.conversantmedia.util.concurrent.AbstractWaitingCondition;
import com.conversantmedia.util.concurrent.BlockingStack;
import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.ContendedAtomicInteger;
import com.conversantmedia.util.concurrent.SequenceLock;
import com.conversantmedia.util.concurrent.SpinPolicy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ConcurrentStack<N>
implements BlockingStack<N> {
    private final int size;
    private final AtomicReferenceArray<N> stack;
    private final ContendedAtomicInteger stackTop = new ContendedAtomicInteger(0);
    private final SequenceLock seqLock = new SequenceLock();
    private final Condition stackNotFullCondition;
    private final Condition stackNotEmptyCondition;

    public ConcurrentStack(int size) {
        this(size, SpinPolicy.WAITING);
    }

    public ConcurrentStack(int size, SpinPolicy spinPolicy) {
        int stackSize = 1;
        while (stackSize < size) {
            stackSize <<= 1;
        }
        this.size = stackSize;
        this.stack = new AtomicReferenceArray(stackSize);
        switch (spinPolicy) {
            case BLOCKING: {
                this.stackNotFullCondition = new StackNotFull();
                this.stackNotEmptyCondition = new StackNotEmpty();
                break;
            }
            case SPINNING: {
                this.stackNotFullCondition = new SpinningStackNotFull();
                this.stackNotEmptyCondition = new SpinningStackNotEmpty();
                break;
            }
            default: {
                this.stackNotFullCondition = new WaitingStackNotFull();
                this.stackNotEmptyCondition = new WaitingStackNotEmpty();
            }
        }
    }

    @Override
    public final boolean push(N n, long time, TimeUnit unit) throws InterruptedException {
        long endDate = System.nanoTime() + unit.toNanos(time);
        while (!this.push(n)) {
            if (endDate - System.nanoTime() < 0L) {
                return false;
            }
            Condition.waitStatus(time, unit, this.stackNotFullCondition);
        }
        this.stackNotEmptyCondition.signal();
        return true;
    }

    @Override
    public final void pushInterruptibly(N n) throws InterruptedException {
        while (!this.push(n)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.stackNotFullCondition.await();
        }
        this.stackNotEmptyCondition.signal();
    }

    @Override
    public final boolean contains(N n) {
        if (n != null) {
            int i = 0;
            while (i < this.stackTop.get()) {
                if (n.equals(this.stack.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean push(N n) {
        int spin = 0;
        while (true) {
            long writeLock;
            if ((writeLock = this.seqLock.tryWriteLock()) > 0L) {
                try {
                    int stackTop = this.stackTop.get();
                    if (this.size <= stackTop) return false;
                    try {
                        this.stack.set(stackTop, n);
                        this.stackNotEmptyCondition.signal();
                        this.stackTop.set(stackTop + 1);
                        return true;
                    }
                    catch (Throwable throwable) {
                        this.stackTop.set(stackTop + 1);
                        throw throwable;
                    }
                }
                finally {
                    this.seqLock.unlock(writeLock);
                }
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    @Override
    public final N peek() {
        int spin = 0;
        while (true) {
            long readLock = this.seqLock.readLock();
            int stackTop = this.stackTop.get();
            if (stackTop > 0) {
                N n = this.stack.get(stackTop - 1);
                if (this.seqLock.readLockHeld(readLock)) {
                    return n;
                }
            } else {
                return null;
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final N pop() {
        int spin = 0;
        while (true) {
            long writeLock;
            if ((writeLock = this.seqLock.tryWriteLock()) > 0L) {
                try {
                    N n;
                    int stackTop = this.stackTop.get();
                    int lastRef = stackTop - 1;
                    if (stackTop <= 0) return null;
                    try {
                        N n2 = this.stack.get(lastRef);
                        this.stack.set(lastRef, null);
                        this.stackNotFullCondition.signal();
                        n = n2;
                        this.stackTop.set(lastRef);
                    }
                    catch (Throwable throwable) {
                        this.stackTop.set(lastRef);
                        throw throwable;
                    }
                    return n;
                }
                finally {
                    this.seqLock.unlock(writeLock);
                }
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    @Override
    public final N pop(long time, TimeUnit unit) throws InterruptedException {
        long endTime = System.nanoTime() + unit.toNanos(time);
        while (true) {
            N n;
            if ((n = this.pop()) != null) {
                this.stackNotFullCondition.signal();
                return n;
            }
            if (endTime - System.nanoTime() < 0L) {
                return null;
            }
            Condition.waitStatus(time, unit, this.stackNotEmptyCondition);
        }
    }

    @Override
    public final N popInterruptibly() throws InterruptedException {
        while (true) {
            N n;
            if ((n = this.pop()) != null) {
                this.stackNotFullCondition.signal();
                return n;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.stackNotEmptyCondition.await();
        }
    }

    @Override
    public final int size() {
        return this.stackTop.get();
    }

    @Override
    public final int remainingCapacity() {
        return this.size - this.stackTop.get();
    }

    @Override
    public final boolean isEmpty() {
        return this.stackTop.get() == 0;
    }

    @Override
    public final void clear() {
        int spin = 0;
        while (true) {
            long writeLock;
            if ((writeLock = this.seqLock.tryWriteLock()) > 0L) {
                int stackTop = this.stackTop.get();
                if (stackTop > 0) {
                    try {
                        int i = 0;
                        while (i < stackTop) {
                            this.stack.set(i, null);
                            ++i;
                        }
                        this.stackNotFullCondition.signal();
                        return;
                    }
                    finally {
                        this.stackTop.set(0);
                    }
                }
                return;
            }
            spin = Condition.progressiveYield(spin);
        }
    }

    private boolean isFull() {
        return this.size == this.stackTop.get();
    }

    private final class SpinningStackNotEmpty
    extends AbstractSpinningCondition {
        private SpinningStackNotEmpty() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isEmpty();
        }
    }

    private final class SpinningStackNotFull
    extends AbstractSpinningCondition {
        private SpinningStackNotFull() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isFull();
        }
    }

    private final class StackNotEmpty
    extends AbstractCondition {
        private StackNotEmpty() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isEmpty();
        }
    }

    private final class StackNotFull
    extends AbstractCondition {
        private StackNotFull() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isFull();
        }
    }

    private final class WaitingStackNotEmpty
    extends AbstractWaitingCondition {
        private WaitingStackNotEmpty() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isEmpty();
        }
    }

    private final class WaitingStackNotFull
    extends AbstractWaitingCondition {
        private WaitingStackNotFull() {
        }

        @Override
        public final boolean test() {
            return ConcurrentStack.this.isFull();
        }
    }
}

