/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.classmate;

import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.AnnotationInclusion;
import com.fasterxml.classmate.Annotations;
import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeBindings;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.RawConstructor;
import com.fasterxml.classmate.members.RawField;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedConstructor;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.util.MethodKey;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ResolvedTypeWithMembers {
    private static final ResolvedType[] NO_RESOLVED_TYPES = new ResolvedType[0];
    private static final ResolvedMethod[] NO_RESOLVED_METHODS = new ResolvedMethod[0];
    private static final ResolvedField[] NO_RESOLVED_FIELDS = new ResolvedField[0];
    private static final ResolvedConstructor[] NO_RESOLVED_CONSTRUCTORS = new ResolvedConstructor[0];
    protected static final AnnotationConfiguration DEFAULT_ANNOTATION_CONFIG = new AnnotationConfiguration.StdConfiguration(AnnotationInclusion.DONT_INCLUDE);
    protected final TypeResolver _typeResolver;
    protected final AnnotationHandler _annotationHandler;
    protected final HierarchicType _mainType;
    protected final HierarchicType[] _types;
    protected Filter<RawField> _fieldFilter;
    protected Filter<RawConstructor> _constructorFilter;
    protected Filter<RawMethod> _methodFilter;
    protected ResolvedMethod[] _staticMethods = null;
    protected ResolvedField[] _staticFields = null;
    protected ResolvedMethod[] _memberMethods = null;
    protected ResolvedField[] _memberFields = null;
    protected ResolvedConstructor[] _constructors = null;

    public ResolvedTypeWithMembers(TypeResolver typeResolver, AnnotationConfiguration annotationConfig, HierarchicType mainType, HierarchicType[] types, Filter<RawConstructor> constructorFilter, Filter<RawField> fieldFilter, Filter<RawMethod> methodFilter) {
        this._typeResolver = typeResolver;
        this._mainType = mainType;
        this._types = types;
        if (annotationConfig == null) {
            annotationConfig = DEFAULT_ANNOTATION_CONFIG;
        }
        this._annotationHandler = new AnnotationHandler(annotationConfig);
        this._constructorFilter = constructorFilter;
        this._fieldFilter = fieldFilter;
        this._methodFilter = methodFilter;
    }

    public int size() {
        return this._types.length;
    }

    public List<HierarchicType> allTypesAndOverrides() {
        return Arrays.asList(this._types);
    }

    public List<HierarchicType> mainTypeAndOverrides() {
        List<HierarchicType> l = Arrays.asList(this._types);
        int end = this._mainType.getPriority() + 1;
        if (end < l.size()) {
            l = l.subList(0, end);
        }
        return l;
    }

    public List<HierarchicType> overridesOnly() {
        int index = this._mainType.getPriority();
        if (index == 0) {
            return Collections.emptyList();
        }
        List<HierarchicType> l = Arrays.asList(this._types);
        return l.subList(0, index);
    }

    public ResolvedField[] getStaticFields() {
        if (this._staticFields == null) {
            this._staticFields = this.resolveStaticFields();
        }
        return this._staticFields;
    }

    public ResolvedMethod[] getStaticMethods() {
        if (this._staticMethods == null) {
            this._staticMethods = this.resolveStaticMethods();
        }
        return this._staticMethods;
    }

    public ResolvedField[] getMemberFields() {
        if (this._memberFields == null) {
            this._memberFields = this.resolveMemberFields();
        }
        return this._memberFields;
    }

    public ResolvedMethod[] getMemberMethods() {
        if (this._memberMethods == null) {
            this._memberMethods = this.resolveMemberMethods();
        }
        return this._memberMethods;
    }

    public ResolvedConstructor[] getConstructors() {
        if (this._constructors == null) {
            this._constructors = this.resolveConstructors();
        }
        return this._constructors;
    }

    protected ResolvedConstructor[] resolveConstructors() {
        LinkedHashMap<MethodKey, ResolvedConstructor> constructors = new LinkedHashMap<MethodKey, ResolvedConstructor>();
        for (RawConstructor constructor : this._mainType.getType().getConstructors()) {
            if (this._constructorFilter != null && !this._constructorFilter.include(constructor)) continue;
            constructors.put(constructor.createKey(), this.resolveConstructor(constructor));
        }
        for (HierarchicType type : this.overridesOnly()) {
            for (RawConstructor raw : type.getType().getConstructors()) {
                ResolvedConstructor constructor = (ResolvedConstructor)constructors.get(raw.createKey());
                if (constructor == null) continue;
                Annotation[] annotationArray = raw.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation ann = annotationArray[n2];
                    if (this._annotationHandler.includeMethodAnnotation(ann)) {
                        constructor.applyOverride(ann);
                    }
                    ++n2;
                }
                Annotation[][] params = ((Constructor)raw.getRawMember()).getParameterAnnotations();
                int i = 0;
                while (i < params.length) {
                    Annotation[] annotationArray2 = params[i];
                    int n3 = annotationArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation annotation = annotationArray2[n4];
                        if (this._annotationHandler.includeParameterAnnotation(annotation)) {
                            constructor.applyParamOverride(i, annotation);
                        }
                        ++n4;
                    }
                    ++i;
                }
            }
        }
        if (constructors.size() == 0) {
            return NO_RESOLVED_CONSTRUCTORS;
        }
        return constructors.values().toArray(new ResolvedConstructor[0]);
    }

    protected ResolvedField[] resolveMemberFields() {
        LinkedHashMap<String, ResolvedField> fields = new LinkedHashMap<String, ResolvedField>();
        int typeIndex = this._types.length;
        while (--typeIndex >= 0) {
            HierarchicType thisType = this._types[typeIndex];
            if (thisType.isMixin()) {
                for (RawField raw : thisType.getType().getMemberFields()) {
                    ResolvedField field;
                    if (this._fieldFilter != null && !this._fieldFilter.include(raw) || (field = (ResolvedField)fields.get(raw.getName())) == null) continue;
                    Annotation[] annotationArray = raw.getAnnotations();
                    int n = annotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Annotation ann = annotationArray[n2];
                        if (this._annotationHandler.includeMethodAnnotation(ann)) {
                            field.applyOverride(ann);
                        }
                        ++n2;
                    }
                }
                continue;
            }
            for (RawField field : thisType.getType().getMemberFields()) {
                if (this._fieldFilter != null && !this._fieldFilter.include(field)) continue;
                fields.put(field.getName(), this.resolveField(field));
            }
        }
        if (fields.size() == 0) {
            return NO_RESOLVED_FIELDS;
        }
        return fields.values().toArray(new ResolvedField[0]);
    }

    protected ResolvedMethod[] resolveMemberMethods() {
        LinkedHashMap<MethodKey, ResolvedMethod> methods = new LinkedHashMap<MethodKey, ResolvedMethod>();
        LinkedHashMap<MethodKey, Annotations> overrides = new LinkedHashMap<MethodKey, Annotations>();
        LinkedHashMap<MethodKey, Annotations[]> paramOverrides = new LinkedHashMap<MethodKey, Annotations[]>();
        for (HierarchicType type : this.allTypesAndOverrides()) {
            for (RawMethod method : type.getType().getMemberMethods()) {
                Annotation ann;
                if (this._methodFilter != null && !this._methodFilter.include(method)) continue;
                MethodKey key = method.createKey();
                ResolvedMethod old = (ResolvedMethod)methods.get(key);
                if (type.isMixin()) {
                    Annotation[] annotationArray = method.getAnnotations();
                    int n = annotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ann = annotationArray[n2];
                        if (old != null) {
                            if (this.methodCanInherit(ann)) {
                                old.applyDefault(ann);
                            }
                        } else {
                            Annotations oldAnn = (Annotations)overrides.get(key);
                            if (oldAnn == null) {
                                oldAnn = new Annotations();
                                oldAnn.add(ann);
                                overrides.put(key, oldAnn);
                            } else {
                                oldAnn.addAsDefault(ann);
                            }
                        }
                        ++n2;
                    }
                    Annotation[][] argAnnotations = method.getRawMember().getParameterAnnotations();
                    if (old == null) {
                        Annotation annotation;
                        Annotation[] annotationArray2;
                        int i;
                        Annotations[] oldParamAnns = (Annotations[])paramOverrides.get(key);
                        if (oldParamAnns == null) {
                            oldParamAnns = new Annotations[argAnnotations.length];
                            i = 0;
                            while (i < argAnnotations.length) {
                                oldParamAnns[i] = new Annotations();
                                annotationArray2 = argAnnotations[i];
                                int n3 = annotationArray2.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    annotation = annotationArray2[n4];
                                    if (this.parameterCanInherit(annotation)) {
                                        oldParamAnns[i].add(annotation);
                                    }
                                    ++n4;
                                }
                                ++i;
                            }
                            paramOverrides.put(key, oldParamAnns);
                            continue;
                        }
                        i = 0;
                        while (i < argAnnotations.length) {
                            annotationArray2 = argAnnotations[i];
                            int n5 = annotationArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                annotation = annotationArray2[n6];
                                if (this.parameterCanInherit(annotation)) {
                                    oldParamAnns[i].addAsDefault(annotation);
                                }
                                ++n6;
                            }
                            ++i;
                        }
                        continue;
                    }
                    int i = 0;
                    while (i < argAnnotations.length) {
                        Annotation[] annotationArray3 = argAnnotations[i];
                        int n7 = annotationArray3.length;
                        int annotation = 0;
                        while (annotation < n7) {
                            Annotation annotation2 = annotationArray3[annotation];
                            if (this.parameterCanInherit(annotation2)) {
                                old.applyParamDefault(i, annotation2);
                            }
                            ++annotation;
                        }
                        ++i;
                    }
                    continue;
                }
                if (old == null) {
                    Annotations[] annotations;
                    ResolvedMethod newMethod = this.resolveMethod(method);
                    methods.put(key, newMethod);
                    Annotations overrideAnn = (Annotations)overrides.get(key);
                    if (overrideAnn != null) {
                        newMethod.applyOverrides(overrideAnn);
                    }
                    if ((annotations = (Annotations[])paramOverrides.get(key)) == null) continue;
                    int i = 0;
                    while (i < annotations.length) {
                        newMethod.applyParamOverrides(i, annotations[i]);
                        ++i;
                    }
                    continue;
                }
                Annotation[] annotationArray = method.getAnnotations();
                int annotations = annotationArray.length;
                int overrideAnn = 0;
                while (overrideAnn < annotations) {
                    ann = annotationArray[overrideAnn];
                    if (this.methodCanInherit(ann)) {
                        old.applyDefault(ann);
                    }
                    ++overrideAnn;
                }
                Annotation[][] parameterAnnotations = method.getRawMember().getParameterAnnotations();
                int i = 0;
                while (i < parameterAnnotations.length) {
                    Annotation[] annotationArray4 = parameterAnnotations[i];
                    int n = annotationArray4.length;
                    int n8 = 0;
                    while (n8 < n) {
                        Annotation annotation = annotationArray4[n8];
                        if (this.parameterCanInherit(annotation)) {
                            old.applyParamDefault(i, annotation);
                        }
                        ++n8;
                    }
                    ++i;
                }
            }
        }
        if (methods.size() == 0) {
            return NO_RESOLVED_METHODS;
        }
        return methods.values().toArray(new ResolvedMethod[0]);
    }

    protected ResolvedField[] resolveStaticFields() {
        LinkedHashMap<String, ResolvedField> fields = new LinkedHashMap<String, ResolvedField>();
        for (RawField field : this._mainType.getType().getStaticFields()) {
            if (this._fieldFilter != null && !this._fieldFilter.include(field)) continue;
            fields.put(field.getName(), this.resolveField(field));
        }
        for (HierarchicType type : this.overridesOnly()) {
            for (RawField raw : type.getType().getStaticFields()) {
                ResolvedField field = (ResolvedField)fields.get(raw.getName());
                if (field == null) continue;
                Annotation[] annotationArray = raw.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation ann = annotationArray[n2];
                    if (this._annotationHandler.includeFieldAnnotation(ann)) {
                        field.applyOverride(ann);
                    }
                    ++n2;
                }
            }
        }
        if (fields.isEmpty()) {
            return NO_RESOLVED_FIELDS;
        }
        return fields.values().toArray(new ResolvedField[0]);
    }

    protected ResolvedMethod[] resolveStaticMethods() {
        LinkedHashMap<MethodKey, ResolvedMethod> methods = new LinkedHashMap<MethodKey, ResolvedMethod>();
        for (RawMethod method : this._mainType.getType().getStaticMethods()) {
            if (this._methodFilter != null && !this._methodFilter.include(method)) continue;
            methods.put(method.createKey(), this.resolveMethod(method));
        }
        for (HierarchicType type : this.overridesOnly()) {
            for (RawMethod raw : type.getType().getStaticMethods()) {
                ResolvedMethod method = (ResolvedMethod)methods.get(raw.createKey());
                if (method == null) continue;
                Annotation[] annotationArray = raw.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation ann = annotationArray[n2];
                    if (this._annotationHandler.includeMethodAnnotation(ann)) {
                        method.applyOverride(ann);
                    }
                    ++n2;
                }
            }
        }
        if (methods.size() == 0) {
            return NO_RESOLVED_METHODS;
        }
        return methods.values().toArray(new ResolvedMethod[0]);
    }

    protected ResolvedConstructor resolveConstructor(RawConstructor raw) {
        ResolvedType[] argTypes;
        ResolvedType context = raw.getDeclaringType();
        TypeBindings bindings = context.getTypeBindings();
        Member ctor = raw.getRawMember();
        Type[] rawTypes = ((Constructor)ctor).getGenericParameterTypes();
        if (rawTypes == null || rawTypes.length == 0) {
            argTypes = NO_RESOLVED_TYPES;
        } else {
            argTypes = new ResolvedType[rawTypes.length];
            int i = 0;
            int len = rawTypes.length;
            while (i < len) {
                argTypes[i] = this._typeResolver.resolve(bindings, rawTypes[i]);
                ++i;
            }
        }
        Annotations anns = new Annotations();
        Annotation[] annotationArray = ((AccessibleObject)((Object)ctor)).getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (this._annotationHandler.includeConstructorAnnotation(ann)) {
                anns.add(ann);
            }
            ++n2;
        }
        ResolvedConstructor constructor = new ResolvedConstructor(context, anns, (Constructor<?>)ctor, argTypes);
        Annotation[][] annotations = ((Constructor)ctor).getParameterAnnotations();
        int i = 0;
        while (i < argTypes.length) {
            Annotation[] annotationArray2 = annotations[i];
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray2[n4];
                constructor.applyParamOverride(i, ann);
                ++n4;
            }
            ++i;
        }
        return constructor;
    }

    protected ResolvedField resolveField(RawField raw) {
        ResolvedType context = raw.getDeclaringType();
        Field field = raw.getRawMember();
        ResolvedType type = this._typeResolver.resolve(context.getTypeBindings(), field.getGenericType());
        Annotations anns = new Annotations();
        Annotation[] annotationArray = field.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (this._annotationHandler.includeFieldAnnotation(ann)) {
                anns.add(ann);
            }
            ++n2;
        }
        return new ResolvedField(context, anns, field, type);
    }

    protected ResolvedMethod resolveMethod(RawMethod raw) {
        ResolvedType[] argTypes;
        ResolvedType context = raw.getDeclaringType();
        TypeBindings bindings = context.getTypeBindings();
        Method m = raw.getRawMember();
        Type rawType = m.getGenericReturnType();
        ResolvedType rt = rawType == Void.TYPE ? null : this._typeResolver.resolve(bindings, rawType);
        Type[] rawTypes = m.getGenericParameterTypes();
        if (rawTypes == null || rawTypes.length == 0) {
            argTypes = NO_RESOLVED_TYPES;
        } else {
            argTypes = new ResolvedType[rawTypes.length];
            int i = 0;
            int len = rawTypes.length;
            while (i < len) {
                argTypes[i] = this._typeResolver.resolve(bindings, rawTypes[i]);
                ++i;
            }
        }
        Annotations anns = new Annotations();
        Annotation[] annotationArray = m.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (this._annotationHandler.includeMethodAnnotation(ann)) {
                anns.add(ann);
            }
            ++n2;
        }
        ResolvedMethod method = new ResolvedMethod(context, anns, m, rt, argTypes);
        Annotation[][] annotations = m.getParameterAnnotations();
        int i = 0;
        while (i < argTypes.length) {
            Annotation[] annotationArray2 = annotations[i];
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray2[n4];
                method.applyParamOverride(i, ann);
                ++n4;
            }
            ++i;
        }
        return method;
    }

    protected boolean methodCanInherit(Annotation annotation) {
        AnnotationInclusion annotationInclusion = this._annotationHandler.methodInclusion(annotation);
        if (annotationInclusion == AnnotationInclusion.INCLUDE_AND_INHERIT_IF_INHERITED) {
            return annotation.annotationType().isAnnotationPresent(Inherited.class);
        }
        return annotationInclusion == AnnotationInclusion.INCLUDE_AND_INHERIT;
    }

    protected boolean parameterCanInherit(Annotation annotation) {
        AnnotationInclusion annotationInclusion = this._annotationHandler.parameterInclusion(annotation);
        if (annotationInclusion == AnnotationInclusion.INCLUDE_AND_INHERIT_IF_INHERITED) {
            return annotation.annotationType().isAnnotationPresent(Inherited.class);
        }
        return annotationInclusion == AnnotationInclusion.INCLUDE_AND_INHERIT;
    }

    private static final class AnnotationHandler {
        private final AnnotationConfiguration _annotationConfig;
        private HashMap<Class<? extends Annotation>, AnnotationInclusion> _fieldInclusions;
        private HashMap<Class<? extends Annotation>, AnnotationInclusion> _constructorInclusions;
        private HashMap<Class<? extends Annotation>, AnnotationInclusion> _methodInclusions;
        private HashMap<Class<? extends Annotation>, AnnotationInclusion> _parameterInclusions;

        public AnnotationHandler(AnnotationConfiguration annotationConfig) {
            this._annotationConfig = annotationConfig;
        }

        public boolean includeConstructorAnnotation(Annotation ann) {
            AnnotationInclusion incl;
            Class<? extends Annotation> annType = ann.annotationType();
            if (this._constructorInclusions == null) {
                this._constructorInclusions = new HashMap();
            } else {
                incl = this._constructorInclusions.get(annType);
                if (incl != null) {
                    return incl != AnnotationInclusion.DONT_INCLUDE;
                }
            }
            incl = this._annotationConfig.getInclusionForConstructor(annType);
            this._constructorInclusions.put(annType, incl);
            return incl != AnnotationInclusion.DONT_INCLUDE;
        }

        public boolean includeFieldAnnotation(Annotation ann) {
            AnnotationInclusion incl;
            Class<? extends Annotation> annType = ann.annotationType();
            if (this._fieldInclusions == null) {
                this._fieldInclusions = new HashMap();
            } else {
                incl = this._fieldInclusions.get(annType);
                if (incl != null) {
                    return incl != AnnotationInclusion.DONT_INCLUDE;
                }
            }
            incl = this._annotationConfig.getInclusionForField(annType);
            this._fieldInclusions.put(annType, incl);
            return incl != AnnotationInclusion.DONT_INCLUDE;
        }

        public boolean includeMethodAnnotation(Annotation ann) {
            return this.methodInclusion(ann) != AnnotationInclusion.DONT_INCLUDE;
        }

        public AnnotationInclusion methodInclusion(Annotation ann) {
            AnnotationInclusion incl;
            Class<? extends Annotation> annType = ann.annotationType();
            if (this._methodInclusions == null) {
                this._methodInclusions = new HashMap();
            } else {
                incl = this._methodInclusions.get(annType);
                if (incl != null) {
                    return incl;
                }
            }
            incl = this._annotationConfig.getInclusionForMethod(annType);
            this._methodInclusions.put(annType, incl);
            return incl;
        }

        public boolean includeParameterAnnotation(Annotation ann) {
            return this.parameterInclusion(ann) != AnnotationInclusion.DONT_INCLUDE;
        }

        public AnnotationInclusion parameterInclusion(Annotation ann) {
            AnnotationInclusion incl;
            Class<? extends Annotation> annType = ann.annotationType();
            if (this._parameterInclusions == null) {
                this._parameterInclusions = new HashMap();
            } else {
                incl = this._parameterInclusions.get(annType);
                if (incl != null) {
                    return incl;
                }
            }
            incl = this._annotationConfig.getInclusionForParameter(annType);
            this._parameterInclusions.put(annType, incl);
            return incl;
        }
    }
}

