/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.TokenRange;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Utils;
import java.util.List;
import java.util.Optional;

public class JavaToken {
    public static final JavaToken INVALID = new JavaToken();
    private Range range;
    private int kind;
    private String text;
    private JavaToken previousToken = null;
    private JavaToken nextToken = null;

    private JavaToken() {
        this(null, 0, "INVALID", null, null);
    }

    public JavaToken(int kind, String text) {
        this(null, kind, text, null, null);
    }

    JavaToken(Token token, List<JavaToken> tokens) {
        Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        String text = token.image;
        if (token.kind == 146) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn);
            text = ">";
        } else if (token.kind == 145) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn + 1);
            text = ">>";
        }
        this.range = range;
        this.kind = token.kind;
        this.text = text;
        if (!tokens.isEmpty()) {
            JavaToken previousToken;
            this.previousToken = previousToken = tokens.get(tokens.size() - 1);
            previousToken.nextToken = this;
        } else {
            this.previousToken = null;
        }
    }

    public JavaToken(int kind) {
        String content = GeneratedJavaParserConstants.tokenImage[kind];
        if (content.startsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        if (TokenTypes.isEndOfLineToken(kind)) {
            content = Utils.SYSTEM_EOL;
        } else if (TokenTypes.isWhitespace(kind)) {
            content = " ";
        }
        this.kind = kind;
        this.text = content;
    }

    public JavaToken(Range range, int kind, String text, JavaToken previousToken, JavaToken nextToken) {
        Utils.assertNotNull(text);
        this.range = range;
        this.kind = kind;
        this.text = text;
        this.previousToken = previousToken;
        this.nextToken = nextToken;
    }

    public Optional<Range> getRange() {
        return Optional.ofNullable(this.range);
    }

    public boolean hasRange() {
        return this.getRange().isPresent();
    }

    public int getKind() {
        return this.kind;
    }

    void setKind(int kind) {
        this.kind = kind;
    }

    public String getText() {
        return this.text;
    }

    public Optional<JavaToken> getNextToken() {
        return Optional.ofNullable(this.nextToken);
    }

    public Optional<JavaToken> getPreviousToken() {
        return Optional.ofNullable(this.previousToken);
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String asString() {
        return this.text;
    }

    public TokenRange toTokenRange() {
        return new TokenRange(this.findFirstToken(), this.findLastToken());
    }

    public String toString() {
        String text = this.getText().replace("\n", "\\n").replace("\r", "\\r").replace("\r\n", "\\r\\n").replace("\t", "\\t");
        return CodeGenerationUtils.f("\"%s\"   <%s>   %s", text, this.getKind(), this.getRange().map(Range::toString).orElse("(?)-(?)"));
    }

    public boolean valid() {
        return !this.invalid();
    }

    public boolean invalid() {
        return this == INVALID;
    }

    public Category getCategory() {
        return TokenTypes.getCategory(this.kind);
    }

    public void insert(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getPreviousToken().ifPresent(p -> {
            p.nextToken = newToken;
            javaToken.previousToken = p;
        });
        this.previousToken = newToken;
        newToken.nextToken = this;
    }

    public void insertAfter(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getNextToken().ifPresent(n -> {
            n.previousToken = newToken;
            javaToken.nextToken = n;
        });
        this.nextToken = newToken;
        newToken.previousToken = this;
    }

    public void deleteToken() {
        Optional<JavaToken> nextToken = this.getNextToken();
        Optional<JavaToken> previousToken = this.getPreviousToken();
        previousToken.ifPresent(p -> {
            JavaToken javaToken = p.nextToken = (JavaToken)nextToken.orElse(null);
        });
        nextToken.ifPresent(n -> {
            JavaToken javaToken = n.previousToken = (JavaToken)previousToken.orElse(null);
        });
    }

    public void replaceToken(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getPreviousToken().ifPresent(p -> {
            p.nextToken = newToken;
            javaToken.previousToken = p;
        });
        this.getNextToken().ifPresent(n -> {
            n.previousToken = newToken;
            javaToken.nextToken = n;
        });
    }

    public JavaToken findLastToken() {
        JavaToken current = this;
        while (current.getNextToken().isPresent()) {
            current = current.getNextToken().get();
        }
        return current;
    }

    public JavaToken findFirstToken() {
        JavaToken current = this;
        while (current.getPreviousToken().isPresent()) {
            current = current.getPreviousToken().get();
        }
        return current;
    }

    public int hashCode() {
        int result = this.kind;
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaToken javaToken = (JavaToken)o;
        if (this.kind != javaToken.kind) {
            return false;
        }
        return this.text.equals(javaToken.text);
    }

    public static enum Category {
        WHITESPACE_NO_EOL,
        EOL,
        COMMENT,
        IDENTIFIER,
        KEYWORD,
        LITERAL,
        SEPARATOR,
        OPERATOR;


        public boolean isWhitespaceOrComment() {
            return this.isWhitespace() || this == COMMENT;
        }

        public boolean isWhitespace() {
            return this == WHITESPACE_NO_EOL || this == EOL;
        }

        public boolean isEndOfLine() {
            return this == EOL;
        }

        public boolean isComment() {
            return this == COMMENT;
        }

        public boolean isWhitespaceButNotEndOfLine() {
            return this == WHITESPACE_NO_EOL;
        }

        public boolean isIdentifier() {
            return this == IDENTIFIER;
        }

        public boolean isKeyword() {
            return this == KEYWORD;
        }

        public boolean isLiteral() {
            return this == LITERAL;
        }

        public boolean isSeparator() {
            return this == SEPARATOR;
        }

        public boolean isOperator() {
            return this == OPERATOR;
        }
    }

    public static enum Kind {
        EOF(0),
        SPACE(1),
        WINDOWS_EOL(2),
        UNIX_EOL(3),
        OLD_MAC_EOL(4),
        SINGLE_LINE_COMMENT(5),
        ENTER_JAVADOC_COMMENT(6),
        ENTER_MULTILINE_COMMENT(7),
        JAVADOC_COMMENT(8),
        MULTI_LINE_COMMENT(9),
        COMMENT_CONTENT(10),
        ABSTRACT(11),
        ASSERT(12),
        BOOLEAN(13),
        BREAK(14),
        BYTE(15),
        CASE(16),
        CATCH(17),
        CHAR(18),
        CLASS(19),
        CONST(20),
        CONTINUE(21),
        _DEFAULT(22),
        DO(23),
        DOUBLE(24),
        ELSE(25),
        ENUM(26),
        EXTENDS(27),
        FALSE(28),
        FINAL(29),
        FINALLY(30),
        FLOAT(31),
        FOR(32),
        GOTO(33),
        IF(34),
        IMPLEMENTS(35),
        IMPORT(36),
        INSTANCEOF(37),
        INT(38),
        INTERFACE(39),
        LONG(40),
        NATIVE(41),
        NEW(42),
        NULL(43),
        PACKAGE(44),
        PRIVATE(45),
        PROTECTED(46),
        PUBLIC(47),
        RECORD(48),
        RETURN(49),
        SHORT(50),
        STATIC(51),
        STRICTFP(52),
        SUPER(53),
        SWITCH(54),
        SYNCHRONIZED(55),
        THIS(56),
        THROW(57),
        THROWS(58),
        TRANSIENT(59),
        TRUE(60),
        TRY(61),
        VOID(62),
        VOLATILE(63),
        WHILE(64),
        YIELD(65),
        REQUIRES(66),
        TO(67),
        WITH(68),
        OPEN(69),
        OPENS(70),
        USES(71),
        MODULE(72),
        EXPORTS(73),
        PROVIDES(74),
        TRANSITIVE(75),
        LONG_LITERAL(76),
        INTEGER_LITERAL(77),
        DECIMAL_LITERAL(78),
        HEX_LITERAL(79),
        OCTAL_LITERAL(80),
        BINARY_LITERAL(81),
        FLOATING_POINT_LITERAL(82),
        DECIMAL_FLOATING_POINT_LITERAL(83),
        DECIMAL_EXPONENT(84),
        HEXADECIMAL_FLOATING_POINT_LITERAL(85),
        HEXADECIMAL_EXPONENT(86),
        HEX_DIGITS(87),
        UNICODE_ESCAPE(88),
        CHARACTER_LITERAL(89),
        STRING_LITERAL(90),
        ENTER_TEXT_BLOCK(91),
        TEXT_BLOCK_LITERAL(92),
        TEXT_BLOCK_CONTENT(93),
        IDENTIFIER(94),
        LETTER(95),
        PART_LETTER(96),
        LPAREN(97),
        RPAREN(98),
        LBRACE(99),
        RBRACE(100),
        LBRACKET(101),
        RBRACKET(102),
        SEMICOLON(103),
        COMMA(104),
        DOT(105),
        ELLIPSIS(106),
        AT(107),
        DOUBLECOLON(108),
        ASSIGN(109),
        LT(110),
        BANG(111),
        TILDE(112),
        HOOK(113),
        COLON(114),
        ARROW(115),
        EQ(116),
        GE(117),
        LE(118),
        NE(119),
        SC_AND(120),
        SC_OR(121),
        INCR(122),
        DECR(123),
        PLUS(124),
        MINUS(125),
        STAR(126),
        SLASH(127),
        BIT_AND(128),
        BIT_OR(129),
        XOR(130),
        REM(131),
        LSHIFT(132),
        PLUSASSIGN(133),
        MINUSASSIGN(134),
        STARASSIGN(135),
        SLASHASSIGN(136),
        ANDASSIGN(137),
        ORASSIGN(138),
        XORASSIGN(139),
        REMASSIGN(140),
        LSHIFTASSIGN(141),
        RSIGNEDSHIFTASSIGN(142),
        RUNSIGNEDSHIFTASSIGN(143),
        RUNSIGNEDSHIFT(144),
        RSIGNEDSHIFT(145),
        GT(146),
        CTRL_Z(147);

        private final int kind;

        private Kind(int kind) {
            this.kind = kind;
        }

        public boolean isPrimitive() {
            return this == BYTE || this == CHAR || this == SHORT || this == INT || this == LONG || this == FLOAT || this == DOUBLE;
        }

        public int getKind() {
            return this.kind;
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }
}

