/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution;

import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametrized;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MethodUsage
implements ResolvedTypeParametrized {
    private ResolvedMethodDeclaration declaration;
    private List<ResolvedType> paramTypes = new ArrayList<ResolvedType>();
    private List<ResolvedType> exceptionTypes = new ArrayList<ResolvedType>();
    private ResolvedType returnType;
    private ResolvedTypeParametersMap typeParametersMap;

    public MethodUsage(ResolvedMethodDeclaration declaration) {
        this.typeParametersMap = ResolvedTypeParametersMap.empty();
        this.declaration = declaration;
        int i = 0;
        while (i < declaration.getNumberOfParams()) {
            this.paramTypes.add(declaration.getParam(i).getType());
            ++i;
        }
        i = 0;
        while (i < declaration.getNumberOfSpecifiedExceptions()) {
            this.exceptionTypes.add(declaration.getSpecifiedException(i));
            ++i;
        }
        this.returnType = declaration.getReturnType();
    }

    public MethodUsage(ResolvedMethodDeclaration declaration, List<ResolvedType> paramTypes, ResolvedType returnType) {
        this(declaration, paramTypes, returnType, declaration.getSpecifiedExceptions(), ResolvedTypeParametersMap.empty());
    }

    public MethodUsage(ResolvedMethodDeclaration declaration, List<ResolvedType> paramTypes, ResolvedType returnType, List<ResolvedType> exceptionTypes) {
        this(declaration, paramTypes, returnType, exceptionTypes, ResolvedTypeParametersMap.empty());
    }

    private MethodUsage(ResolvedMethodDeclaration declaration, List<ResolvedType> paramTypes, ResolvedType returnType, List<ResolvedType> exceptionTypes, ResolvedTypeParametersMap typeParametersMap) {
        this.declaration = declaration;
        this.paramTypes = paramTypes;
        this.returnType = returnType;
        this.exceptionTypes = exceptionTypes;
        this.typeParametersMap = typeParametersMap;
    }

    public String toString() {
        return "MethodUsage{declaration=" + this.declaration + ", paramTypes=" + this.paramTypes + '}';
    }

    public ResolvedMethodDeclaration getDeclaration() {
        return this.declaration;
    }

    public String getName() {
        return this.declaration.getName();
    }

    public ResolvedReferenceTypeDeclaration declaringType() {
        return this.declaration.declaringType();
    }

    public ResolvedType returnType() {
        return this.returnType;
    }

    public List<ResolvedType> getParamTypes() {
        return this.paramTypes;
    }

    public MethodUsage replaceParamType(int i, ResolvedType replaced) {
        if (i < 0 || i >= this.getNoParams()) {
            throw new IllegalArgumentException();
        }
        if (this.paramTypes.get(i) == replaced) {
            return this;
        }
        LinkedList<ResolvedType> newParams = new LinkedList<ResolvedType>(this.paramTypes);
        newParams.set(i, replaced);
        return new MethodUsage(this.declaration, newParams, this.returnType, this.exceptionTypes, this.typeParametersMap);
    }

    public MethodUsage replaceExceptionType(int i, ResolvedType replaced) {
        if (i < 0 || i >= this.exceptionTypes.size()) {
            throw new IllegalArgumentException();
        }
        if (this.exceptionTypes.get(i) == replaced) {
            return this;
        }
        LinkedList<ResolvedType> newTypes = new LinkedList<ResolvedType>(this.exceptionTypes);
        newTypes.set(i, replaced);
        return new MethodUsage(this.declaration, this.paramTypes, this.returnType, newTypes, this.typeParametersMap);
    }

    public MethodUsage replaceReturnType(ResolvedType returnType) {
        if (returnType == this.returnType) {
            return this;
        }
        return new MethodUsage(this.declaration, this.paramTypes, returnType, this.exceptionTypes, this.typeParametersMap);
    }

    public int getNoParams() {
        return this.paramTypes.size();
    }

    public ResolvedType getParamType(int i) {
        return this.paramTypes.get(i);
    }

    public MethodUsage replaceTypeParameter(ResolvedTypeParameterDeclaration typeParameter, ResolvedType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        MethodUsage res = new MethodUsage(this.declaration, this.paramTypes, this.returnType, this.exceptionTypes, this.typeParametersMap.toBuilder().setValue(typeParameter, type).build());
        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
        int i = 0;
        while (i < this.paramTypes.size()) {
            ResolvedType originalParamType = this.paramTypes.get(i);
            ResolvedType newParamType = originalParamType.replaceTypeVariables(typeParameter, type, inferredTypes);
            res = res.replaceParamType(i, newParamType);
            ++i;
        }
        i = 0;
        while (i < this.exceptionTypes.size()) {
            ResolvedType originalType = this.exceptionTypes.get(i);
            ResolvedType newType = originalType.replaceTypeVariables(typeParameter, type, inferredTypes);
            res = res.replaceExceptionType(i, newType);
            ++i;
        }
        ResolvedType oldReturnType = res.returnType;
        ResolvedType newReturnType = oldReturnType.replaceTypeVariables(typeParameter, type, inferredTypes);
        res = res.replaceReturnType(newReturnType);
        return res;
    }

    @Override
    public ResolvedTypeParametersMap typeParametersMap() {
        return this.typeParametersMap;
    }

    public String getQualifiedSignature() {
        return String.valueOf(this.getDeclaration().declaringType().getQualifiedName()) + "." + this.getSignature();
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        int i = 0;
        while (i < this.getNoParams()) {
            ResolvedType type;
            if (i != 0) {
                sb.append(", ");
            }
            if ((type = this.getParamType(i)).isArray() && this.getDeclaration().getParam(i).isVariadic()) {
                sb.append(type.asArrayType().getComponentType().describe()).append("...");
            } else {
                sb.append(type.describe());
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public List<ResolvedType> exceptionTypes() {
        return this.exceptionTypes;
    }
}

