/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BSpline;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ValueVector;

public class NURBSpline
extends BSpline {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private ValueVector weightVector = new ValueVector(new double[]{1.0, 1.0, 1.0, 1.0}, 4);
    private boolean useWeightVector = true;

    public NURBSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p) {
        int dim = p.length - 1;
        double t = p[dim];
        double sum2 = 0.0;
        int numPts = this.gi.getGroupSize();
        int i = 0;
        while (i < numPts) {
            this.sharedData.nw[i] = this.N(t, i) * this.sharedData.weight[i];
            sum2 += this.sharedData.nw[i];
            ++i;
        }
        if (sum2 == 0.0) {
            sum2 = 1.0;
        }
        i = 0;
        while (i < dim) {
            double sum1 = 0.0;
            this.gi.set(0, 0);
            int j = 0;
            while (j < numPts) {
                sum1 += this.sharedData.nw[j] * this.cp.getPoint(this.gi.next()).getLocation()[i];
                ++j;
            }
            p[i] = sum1 / sum2;
            ++i;
        }
    }

    public ValueVector getWeightVector() {
        return this.weightVector;
    }

    public void setWeightVector(ValueVector v) {
        if (v == null) {
            throw new IllegalArgumentException("Weight-vector cannot be null.");
        }
        this.weightVector = v;
    }

    public boolean getUseWeightVector() {
        return this.useWeightVector;
    }

    public void setUseWeightVector(boolean b) {
        this.useWeightVector = b;
    }

    @Override
    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int numPts = this.gi.getGroupSize();
        if (this.sharedData.nw.length < numPts) {
            this.sharedData.nw = new double[2 * numPts];
            this.sharedData.weight = new double[2 * numPts];
        }
        if (this.useWeightVector) {
            if (this.weightVector.size() != numPts) {
                throw new IllegalArgumentException("weightVector.size(" + this.weightVector.size() + ") != group iterator size(" + numPts + ")");
            }
            int i = 0;
            while (i < numPts) {
                this.sharedData.weight[i] = this.weightVector.get(i);
                if (this.sharedData.weight[i] < 0.0) {
                    throw new IllegalArgumentException("Negative weight not allowed");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < numPts) {
                this.sharedData.weight[i] = 1.0;
                ++i;
            }
        }
        super.appendTo(mp);
    }

    @Override
    public void resetMemory() {
        super.resetMemory();
        if (this.sharedData.nw.length > 0) {
            this.sharedData.nw = new double[0];
            this.sharedData.weight = new double[0];
        }
    }

    private static class SharedData {
        private double[] nw = new double[0];
        private double[] weight = new double[0];

        private SharedData() {
        }
    }
}

