/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class NaturalCubicSpline
extends ParametricCurve {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private boolean closed = false;

    public NaturalCubicSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p) {
        int n = p.length - 1;
        double t = p[n];
        double t2 = t * t;
        double t3 = t2 * t;
        int j = 0;
        int i = 0;
        while (i < n) {
            p[i] = this.sharedData.data[j++][this.sharedData.ci] + this.sharedData.data[j++][this.sharedData.ci] * t + this.sharedData.data[j++][this.sharedData.ci] * t2 + this.sharedData.data[j++][this.sharedData.ci] * t3;
            ++i;
        }
    }

    private void precalc(int n, int dim, boolean closed) {
        --n;
        double[] a = this.sharedData.data[4 * dim];
        double[] b = this.sharedData.data[4 * dim + 1];
        double[] c = this.sharedData.data[4 * dim + 2];
        int k = 0;
        if (closed) {
            double[] d = this.sharedData.data[4 * dim + 3];
            int j = 0;
            while (j < dim) {
                double e = 0.25;
                a[1] = 0.25;
                d[1] = 0.25;
                b[0] = e * 3.0 * (this.sharedData.pt[1][j] - this.sharedData.pt[n][j]);
                double h = 4.0;
                double f = 3.0 * (this.sharedData.pt[0][j] - this.sharedData.pt[n - 1][j]);
                double g = 1.0;
                int i = 1;
                while (i < n) {
                    a[i + 1] = e = 1.0 / (4.0 - a[i]);
                    d[i + 1] = -e * d[i];
                    b[i] = e * (3.0 * (this.sharedData.pt[i + 1][j] - this.sharedData.pt[i - 1][j]) - b[i - 1]);
                    h -= g * d[i];
                    f -= g * b[i - 1];
                    g = -a[i] * g;
                    ++i;
                }
                b[n] = f - (g + 1.0) * b[n - 1];
                c[n] = b[n] / (h -= (g + 1.0) * (a[n] + d[n]));
                c[n - 1] = b[n - 1] - (a[n] + d[n]) * c[n];
                i = n - 2;
                while (i >= 0) {
                    c[i] = b[i] - a[i + 1] * c[i + 1] - d[i + 1] * c[n];
                    --i;
                }
                double[] w = this.sharedData.data[k++];
                double[] x = this.sharedData.data[k++];
                double[] y = this.sharedData.data[k++];
                double[] z = this.sharedData.data[k++];
                int i2 = 0;
                while (i2 < n) {
                    w[i2] = this.sharedData.pt[i2][j];
                    x[i2] = c[i2];
                    y[i2] = 3.0 * (this.sharedData.pt[i2 + 1][j] - this.sharedData.pt[i2][j]) - 2.0 * c[i2] - c[i2 + 1];
                    z[i2] = 2.0 * (this.sharedData.pt[i2][j] - this.sharedData.pt[i2 + 1][j]) + c[i2] + c[i2 + 1];
                    ++i2;
                }
                w[n] = this.sharedData.pt[n][j];
                x[n] = c[n];
                y[n] = 3.0 * (this.sharedData.pt[0][j] - this.sharedData.pt[n][j]) - 2.0 * c[n] - c[0];
                z[n] = 2.0 * (this.sharedData.pt[n][j] - this.sharedData.pt[0][j]) + c[n] + c[0];
                ++j;
            }
        } else {
            int j = 0;
            while (j < dim) {
                a[0] = 0.5;
                int i = 1;
                while (i < n) {
                    a[i] = 1.0 / (4.0 - a[i - 1]);
                    ++i;
                }
                a[n] = 1.0 / (2.0 - a[n - 1]);
                b[0] = a[0] * (3.0 * (this.sharedData.pt[1][j] - this.sharedData.pt[0][j]));
                i = 1;
                while (i < n) {
                    b[i] = a[i] * (3.0 * (this.sharedData.pt[i + 1][j] - this.sharedData.pt[i - 1][j]) - b[i - 1]);
                    ++i;
                }
                b[n] = a[n] * (3.0 * (this.sharedData.pt[n][j] - this.sharedData.pt[n - 1][j]) - b[n - 1]);
                c[n] = b[n];
                i = n - 1;
                while (i >= 0) {
                    c[i] = b[i] - a[i] * c[i + 1];
                    --i;
                }
                double[] w = this.sharedData.data[k++];
                double[] x = this.sharedData.data[k++];
                double[] y = this.sharedData.data[k++];
                double[] z = this.sharedData.data[k++];
                int i3 = 0;
                while (i3 < n) {
                    w[i3] = this.sharedData.pt[i3][j];
                    x[i3] = c[i3];
                    y[i3] = 3.0 * (this.sharedData.pt[i3 + 1][j] - this.sharedData.pt[i3][j]) - 2.0 * c[i3] - c[i3 + 1];
                    z[i3] = 2.0 * (this.sharedData.pt[i3][j] - this.sharedData.pt[i3 + 1][j]) + c[i3] + c[i3 + 1];
                    ++i3;
                }
                w[n] = this.sharedData.pt[n][j];
                x[n] = 0.0;
                y[n] = 0.0;
                z[n] = 0.0;
                ++j;
            }
        }
    }

    public void setClosed(boolean b) {
        this.closed = b;
    }

    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Override
    public void appendTo(MultiPath mp) {
        int i;
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int n = this.gi.getGroupSize();
        if (n < 2) {
            throw new IllegalArgumentException("Group iterator size < 2");
        }
        int dim = mp.getDimension();
        int x = 3 + 4 * dim + 1;
        if (this.sharedData.data.length < x) {
            double[][] temp = new double[x][];
            i = 0;
            while (i < this.sharedData.data.length) {
                temp[i] = this.sharedData.data[i];
                ++i;
            }
            this.sharedData.data = temp;
        }
        if (this.sharedData.pt.length < n) {
            int m = 2 * n;
            this.sharedData.pt = new double[m][];
            i = 0;
            while (i < this.sharedData.data.length) {
                this.sharedData.data[i] = new double[m];
                ++i;
            }
        }
        this.gi.set(0, 0);
        int i2 = 0;
        while (i2 < n) {
            this.sharedData.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
            ++i2;
        }
        this.precalc(n, dim, this.closed);
        this.sharedData.ci = 0;
        double[] p = new double[dim + 1];
        this.eval(p);
        if (this.connect) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        i = 0;
        while (i < n) {
            this.sharedData.ci = i++;
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void resetMemory() {
        if (this.sharedData.pt.length > 0) {
            this.sharedData.pt = new double[0][];
        }
        if (this.sharedData.data.length > 0) {
            this.sharedData.data = new double[0][];
        }
    }

    private static class SharedData {
        private double[][] pt = new double[0][];
        private double[][] data = new double[0][];
        private int ci = 0;

        private SharedData() {
        }
    }
}

