/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
@ElementTypesAreNonnullByDefault
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        HashFunction[] hashFunctionArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            HashFunction function = hashFunctionArray[n2];
            Preconditions.checkNotNull(function);
            ++n2;
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hashers = new Hasher[this.functions.length];
        int i = 0;
        while (i < hashers.length) {
            hashers[i] = this.functions[i].newHasher();
            ++i;
        }
        return this.fromHashers(hashers);
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0);
        Hasher[] hashers = new Hasher[this.functions.length];
        int i = 0;
        while (i < hashers.length) {
            hashers[i] = this.functions[i].newHasher(expectedInputSize);
            ++i;
        }
        return this.fromHashers(hashers);
    }

    private Hasher fromHashers(final Hasher[] hashers) {
        return new Hasher(){

            @Override
            public Hasher putByte(byte b) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putByte(b);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putBytes(bytes);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes, int off, int len) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putBytes(bytes, off, len);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer bytes) {
                int pos = bytes.position();
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    Java8Compatibility.position(bytes, pos);
                    hasher.putBytes(bytes);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putShort(short s) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putShort(s);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putInt(int i) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putInt(i);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putLong(long l) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putLong(l);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putFloat(f);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putDouble(d);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putBoolean(b);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putChar(char c) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putChar(c);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putUnencodedChars(chars);
                    ++n2;
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars, Charset charset) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putString(chars, charset);
                    ++n2;
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
                Hasher[] hasherArray = hashers;
                int n = hashers.length;
                int n2 = 0;
                while (n2 < n) {
                    Hasher hasher = hasherArray[n2];
                    hasher.putObject(instance, funnel);
                    ++n2;
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hashers);
            }
        };
    }
}

