/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@ElementTypesAreNonnullByDefault
@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public final Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int i = 0;
        int len = charSequence.length();
        while (i < len) {
            this.putChar(charSequence.charAt(i));
            ++i;
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        int i = 0;
        while (i < len) {
            this.putByte(bytes[off + i]);
            ++i;
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b) {
        if (b.hasArray()) {
            this.putBytes(b.array(), b.arrayOffset() + b.position(), b.remaining());
            Java8Compatibility.position(b, b.limit());
        } else {
            int remaining = b.remaining();
            while (remaining > 0) {
                this.putByte(b.get());
                --remaining;
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s) {
        this.putByte((byte)s);
        this.putByte((byte)(s >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int i) {
        this.putByte((byte)i);
        this.putByte((byte)(i >>> 8));
        this.putByte((byte)(i >>> 16));
        this.putByte((byte)(i >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l) {
        int i = 0;
        while (i < 64) {
            this.putByte((byte)(l >>> i));
            i += 8;
        }
        return this;
    }

    @Override
    public Hasher putChar(char c) {
        this.putByte((byte)c);
        this.putByte((byte)(c >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

