/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;

@Beta
@GwtCompatible
public enum PublicSuffixType {
    PRIVATE(':', ','),
    REGISTRY('!', '?');

    private final char innerNodeCode;
    private final char leafNodeCode;

    private PublicSuffixType(char innerNodeCode, char leafNodeCode) {
        this.innerNodeCode = innerNodeCode;
        this.leafNodeCode = leafNodeCode;
    }

    char getLeafNodeCode() {
        return this.leafNodeCode;
    }

    char getInnerNodeCode() {
        return this.innerNodeCode;
    }

    static PublicSuffixType fromCode(char code) {
        PublicSuffixType[] publicSuffixTypeArray = PublicSuffixType.values();
        int n = publicSuffixTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PublicSuffixType value = publicSuffixTypeArray[n2];
            if (value.getInnerNodeCode() == code || value.getLeafNodeCode() == code) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No enum corresponding to given code: " + code);
    }
}

