/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.JackcessException;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.SqlHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class DataType
extends Enum<DataType> {
    public static final /* enum */ DataType BOOLEAN;
    public static final /* enum */ DataType BYTE;
    public static final /* enum */ DataType INT;
    public static final /* enum */ DataType LONG;
    public static final /* enum */ DataType MONEY;
    public static final /* enum */ DataType FLOAT;
    public static final /* enum */ DataType DOUBLE;
    public static final /* enum */ DataType SHORT_DATE_TIME;
    public static final /* enum */ DataType BINARY;
    public static final /* enum */ DataType TEXT;
    public static final /* enum */ DataType OLE;
    public static final /* enum */ DataType MEMO;
    public static final /* enum */ DataType UNKNOWN_0D;
    public static final /* enum */ DataType GUID;
    public static final /* enum */ DataType NUMERIC;
    public static final /* enum */ DataType UNKNOWN_11;
    public static final /* enum */ DataType COMPLEX_TYPE;
    public static final /* enum */ DataType BIG_INT;
    public static final /* enum */ DataType EXT_DATE_TIME;
    public static final /* enum */ DataType UNSUPPORTED_FIXEDLEN;
    public static final /* enum */ DataType UNSUPPORTED_VARLEN;
    private static final Map<Integer, DataType[]> SQL_TYPES;
    private static final Map<Integer, DataType> ALT_SQL_TYPES;
    private static Map<Byte, DataType> DATA_TYPES;
    private final boolean _variableLength;
    private final boolean _longValue;
    private final boolean _hasScalePrecision;
    private final byte _value;
    private final Integer _fixedSize;
    private final int _minSize;
    private final int _defaultSize;
    private final int _maxSize;
    private final Integer _sqlType;
    private final int _minScale;
    private final int _defaultScale;
    private final int _maxScale;
    private final int _minPrecision;
    private final int _defaultPrecision;
    private final int _maxPrecision;
    private final int _unitSize;
    private static final /* synthetic */ DataType[] ENUM$VALUES;

    static {
        DataType type;
        BOOLEAN = new DataType(1, 16, 0);
        BYTE = new DataType(2, -6, 1);
        INT = new DataType(3, 5, 2);
        LONG = new DataType(4, 4, 4);
        MONEY = new DataType(5, 3, 8, false, false, 0, 0, 0, false, 4, 4, 4, 19, 19, 19, 1);
        FLOAT = new DataType(6, 6, 4);
        DOUBLE = new DataType(7, 8, 8);
        SHORT_DATE_TIME = new DataType(8, 93, 8);
        BINARY = new DataType(9, -2, null, true, false, 0, 255, 255, 1);
        TEXT = new DataType(10, 12, null, true, false, 0, 510, 510, 2);
        OLE = new DataType(11, -4, null, true, true, 0, 0, 0x3FFFFFFF, 1);
        MEMO = new DataType(12, -1, null, true, true, 0, 0, 0x3FFFFFFF, 2);
        UNKNOWN_0D = new DataType(13, null, null, true, false, 0, 255, 255, 1);
        GUID = new DataType(15, null, 16);
        NUMERIC = new DataType(16, 2, 17, true, false, 17, 17, 17, true, 0, 0, 28, 1, 18, 28, 1);
        UNKNOWN_11 = new DataType(17, null, 3992);
        COMPLEX_TYPE = new DataType(18, null, 4);
        BIG_INT = new DataType(19, -5, 8);
        EXT_DATE_TIME = new DataType(20, null, 42);
        UNSUPPORTED_FIXEDLEN = new DataType(-2, null, null);
        UNSUPPORTED_VARLEN = new DataType(-1, null, null, true, false, 0, 0, 0x3FFFFFFF, 1);
        ENUM$VALUES = new DataType[]{BOOLEAN, BYTE, INT, LONG, MONEY, FLOAT, DOUBLE, SHORT_DATE_TIME, BINARY, TEXT, OLE, MEMO, UNKNOWN_0D, GUID, NUMERIC, UNKNOWN_11, COMPLEX_TYPE, BIG_INT, EXT_DATE_TIME, UNSUPPORTED_FIXEDLEN, UNSUPPORTED_VARLEN};
        SQL_TYPES = new HashMap<Integer, DataType[]>();
        ALT_SQL_TYPES = new HashMap<Integer, DataType>();
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = dataTypeArray[n2];
            if (type._sqlType != null) {
                SQL_TYPES.put(type._sqlType, new DataType[]{type});
            }
            ++n2;
        }
        SQL_TYPES.put(-7, new DataType[]{BYTE});
        SQL_TYPES.put(2004, new DataType[]{OLE});
        SQL_TYPES.put(2005, new DataType[]{MEMO});
        SQL_TYPES.put(-5, new DataType[]{LONG, BIG_INT});
        SQL_TYPES.put(1, new DataType[]{TEXT});
        SQL_TYPES.put(91, new DataType[]{SHORT_DATE_TIME});
        SQL_TYPES.put(7, new DataType[]{DOUBLE});
        SQL_TYPES.put(92, new DataType[]{SHORT_DATE_TIME});
        SQL_TYPES.put(-3, new DataType[]{BINARY});
        ALT_SQL_TYPES.put(12, MEMO);
        ALT_SQL_TYPES.put(-3, OLE);
        ALT_SQL_TYPES.put(-2, OLE);
        DataType.addNewSqlType("NCHAR", TEXT, null);
        DataType.addNewSqlType("NVARCHAR", TEXT, MEMO);
        DataType.addNewSqlType("LONGNVARCHAR", MEMO, null);
        DataType.addNewSqlType("NCLOB", MEMO, null);
        DataType.addNewSqlType("TIME_WITH_TIMEZONE", SHORT_DATE_TIME, null);
        DataType.addNewSqlType("TIMESTAMP_WITH_TIMEZONE", SHORT_DATE_TIME, null);
        DATA_TYPES = new HashMap<Byte, DataType>();
        dataTypeArray = DataType.values();
        n = dataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            type = dataTypeArray[n2];
            if (!type.isUnsupported()) {
                DATA_TYPES.put(type._value, type);
            }
            ++n2;
        }
    }

    private DataType(byte value) {
        this(value, null, null);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize) {
        this(value, sqlType, fixedSize, false, false, 0, 0, 0, 1);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, int minSize, int defaultSize, int maxSize, int unitSize) {
        this(value, sqlType, fixedSize, variableLength, longValue, minSize, defaultSize, maxSize, false, 0, 0, 0, 0, 0, 0, unitSize);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, int minSize, int defaultSize, int maxSize, boolean hasScalePrecision, int minScale, int defaultScale, int maxScale, int minPrecision, int defaultPrecision, int maxPrecision, int unitSize) {
        this._value = value;
        this._sqlType = sqlType;
        this._fixedSize = fixedSize;
        this._variableLength = variableLength;
        this._longValue = longValue;
        this._minSize = minSize;
        this._defaultSize = defaultSize;
        this._maxSize = maxSize;
        this._hasScalePrecision = hasScalePrecision;
        this._minScale = minScale;
        this._defaultScale = defaultScale;
        this._maxScale = maxScale;
        this._minPrecision = minPrecision;
        this._defaultPrecision = defaultPrecision;
        this._maxPrecision = maxPrecision;
        this._unitSize = unitSize;
    }

    public byte getValue() {
        return this._value;
    }

    public boolean isVariableLength() {
        return this._variableLength;
    }

    public boolean isTrueVariableLength() {
        return this.isVariableLength() && this.getMinSize() != this.getMaxSize();
    }

    public boolean isLongValue() {
        return this._longValue;
    }

    public boolean getHasScalePrecision() {
        return this._hasScalePrecision;
    }

    public int getFixedSize() {
        return this.getFixedSize(null);
    }

    public int getFixedSize(Short colLength) {
        if (this._fixedSize != null) {
            if (colLength != null) {
                return Math.max(this._fixedSize, colLength.shortValue());
            }
            return this._fixedSize;
        }
        if (colLength != null) {
            return colLength.shortValue();
        }
        throw new IllegalArgumentException("Unexpected fixed length column " + (Object)((Object)this));
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getDefaultSize() {
        return this._defaultSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSQLType() throws IOException {
        if (this._sqlType != null) {
            return this._sqlType;
        }
        throw new JackcessException("Unsupported data type: " + this.toString());
    }

    public int getMinScale() {
        return this._minScale;
    }

    public int getDefaultScale() {
        return this._defaultScale;
    }

    public int getMaxScale() {
        return this._maxScale;
    }

    public int getMinPrecision() {
        return this._minPrecision;
    }

    public int getDefaultPrecision() {
        return this._defaultPrecision;
    }

    public int getMaxPrecision() {
        return this._maxPrecision;
    }

    public int getUnitSize() {
        return this._unitSize;
    }

    public int getUnitSize(JetFormat format) {
        if (format != null && this.isTextual()) {
            return format.SIZE_TEXT_FIELD_UNIT;
        }
        return this._unitSize;
    }

    public int toUnitSize(int size) {
        return this.toUnitSize(size, null);
    }

    public int toUnitSize(int size, JetFormat format) {
        return size / this.getUnitSize(format);
    }

    public int fromUnitSize(int unitSize) {
        return this.fromUnitSize(unitSize, null);
    }

    public int fromUnitSize(int unitSize, JetFormat format) {
        return unitSize * this.getUnitSize(format);
    }

    public boolean isValidSize(int size) {
        return DataType.isWithinRange(size, this.getMinSize(), this.getMaxSize());
    }

    public boolean isValidScale(int scale) {
        return DataType.isWithinRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public boolean isValidPrecision(int precision) {
        return DataType.isWithinRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    private static boolean isWithinRange(int value, int minValue, int maxValue) {
        return value >= minValue && value <= maxValue;
    }

    public int toValidSize(int size) {
        return DataType.toValidRange(size, this.getMinSize(), this.getMaxSize());
    }

    public int toValidScale(int scale) {
        return DataType.toValidRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public int toValidPrecision(int precision) {
        return DataType.toValidRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    public boolean isTextual() {
        return this == TEXT || this == MEMO;
    }

    public boolean mayBeAutoNumber() {
        return this == LONG || this == GUID || this == COMPLEX_TYPE;
    }

    public boolean isMultipleAutoNumberAllowed() {
        return this == COMPLEX_TYPE;
    }

    public boolean isUnsupported() {
        return this == UNSUPPORTED_FIXEDLEN || this == UNSUPPORTED_VARLEN;
    }

    private static int toValidRange(int value, int minValue, int maxValue) {
        return value > maxValue ? maxValue : (value < minValue ? minValue : value);
    }

    public static DataType fromByte(byte b) throws IOException {
        DataType rtn = DATA_TYPES.get(b);
        if (rtn != null) {
            return rtn;
        }
        throw new IOException("Unrecognized data type: " + b);
    }

    public static DataType fromSQLType(int sqlType) throws IOException {
        return DataType.fromSQLType(sqlType, 0, null);
    }

    public static DataType fromSQLType(int sqlType, int lengthInUnits) throws IOException {
        return DataType.fromSQLType(sqlType, lengthInUnits, null);
    }

    public static DataType fromSQLType(int sqlType, int lengthInUnits, Database.FileFormat fileFormat) throws IOException {
        DataType altRtn;
        DataType[] rtnArr = SQL_TYPES.get(sqlType);
        if (rtnArr == null) {
            throw new JackcessException("Unsupported SQL type: " + sqlType);
        }
        JetFormat format = fileFormat != null ? DatabaseImpl.getFileFormatDetails(fileFormat).getFormat() : null;
        DataType rtn = rtnArr[0];
        if (rtnArr.length > 1 && format != null) {
            int i = rtnArr.length - 1;
            while (i >= 0) {
                DataType tmp = rtnArr[i];
                if (format.isSupportedDataType(tmp)) {
                    rtn = tmp;
                    break;
                }
                --i;
            }
        }
        int size = rtn.fromUnitSize(lengthInUnits, format);
        if (rtn.isVariableLength() && !rtn.isValidSize(size) && (altRtn = ALT_SQL_TYPES.get(sqlType)) != null && (altRtn.isLongValue() || altRtn.isValidSize(size))) {
            rtn = altRtn;
        }
        return rtn;
    }

    private static void addNewSqlType(String typeName, DataType type, DataType altType) {
        try {
            Integer value = SqlHelper.INSTANCE.getNewSqlType(typeName);
            SQL_TYPES.put(value, new DataType[]{type});
            if (altType != null) {
                ALT_SQL_TYPES.put(value, altType);
            }
        }
        catch (Exception exception) {}
    }

    public static DataType[] values() {
        DataType[] dataTypeArray = ENUM$VALUES;
        int n = dataTypeArray.length;
        DataType[] dataTypeArray2 = new DataType[n];
        System.arraycopy(ENUM$VALUES, 0, dataTypeArray2, 0, n);
        return dataTypeArray2;
    }

    public static DataType valueOf(String string) {
        return Enum.valueOf(DataType.class, string);
    }
}

