/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.expr;

import com.healthmarketscience.jackcess.expr.Value;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class TemporalConfig {
    public static final String US_DATE_FORMAT = "M/d[/uuuu]";
    public static final String US_TIME_FORMAT_12_FORMAT = "h:mm:ss a";
    public static final String US_TIME_FORMAT_24_FORMAT = "H:mm:ss";
    public static final String US_LONG_DATE_FORMAT = "EEEE, MMMM dd, uuuu";
    public static final String MEDIUM_DATE_FORMAT = "dd-MMM-uu";
    public static final String MEDIUM_TIME_FORMAT = "hh:mm a";
    public static final String SHORT_TIME_FORMAT = "HH:mm";
    public static final TemporalConfig US_TEMPORAL_CONFIG = new TemporalConfig("M/d[/uuuu]", "EEEE, MMMM dd, uuuu", "h:mm:ss a", "H:mm:ss", '/', ':', Locale.US);
    private final Locale _locale;
    private final String _dateFormat;
    private final String _longDateFormat;
    private final String _timeFormat12;
    private final String _timeFormat24;
    private final char _dateSeparator;
    private final char _timeSeparator;
    private final String _dateTimeFormat12;
    private final String _dateTimeFormat24;
    private final String[] _amPmStrings;

    public TemporalConfig(String dateFormat, String longDateFormat, String timeFormat12, String timeFormat24, char dateSeparator, char timeSeparator, Locale locale) {
        this._locale = locale;
        this._dateFormat = dateFormat;
        this._longDateFormat = longDateFormat;
        this._timeFormat12 = timeFormat12;
        this._timeFormat24 = timeFormat24;
        this._dateSeparator = dateSeparator;
        this._timeSeparator = timeSeparator;
        this._dateTimeFormat12 = TemporalConfig.toDateTimeFormat(this._dateFormat, this._timeFormat12);
        this._dateTimeFormat24 = TemporalConfig.toDateTimeFormat(this._dateFormat, this._timeFormat24);
        this._amPmStrings = DateFormatSymbols.getInstance(locale).getAmPmStrings();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public String getTimeFormat12() {
        return this._timeFormat12;
    }

    public String getTimeFormat24() {
        return this._timeFormat24;
    }

    public String getDateTimeFormat12() {
        return this._dateTimeFormat12;
    }

    public String getDateTimeFormat24() {
        return this._dateTimeFormat24;
    }

    public String getDefaultDateFormat() {
        return this.getDateFormat();
    }

    public String getDefaultTimeFormat() {
        return this.getTimeFormat12();
    }

    public String getDefaultDateTimeFormat() {
        return this.getDateTimeFormat12();
    }

    public char getDateSeparator() {
        return this._dateSeparator;
    }

    public char getTimeSeparator() {
        return this._timeSeparator;
    }

    public String getDateTimeFormat(Type type) {
        switch (type) {
            case DATE: 
            case SHORT_DATE: {
                return this.getDefaultDateFormat();
            }
            case TIME: {
                return this.getDefaultTimeFormat();
            }
            case DATE_TIME: 
            case GENERAL_DATE: {
                return this.getDefaultDateTimeFormat();
            }
            case TIME_12: 
            case LONG_TIME: {
                return this.getTimeFormat12();
            }
            case TIME_24: {
                return this.getTimeFormat24();
            }
            case DATE_TIME_12: {
                return this.getDateTimeFormat12();
            }
            case DATE_TIME_24: {
                return this.getDateTimeFormat24();
            }
            case LONG_DATE: {
                return this.getLongDateFormat();
            }
            case MEDIUM_DATE: {
                return this.getMediumDateFormat();
            }
            case MEDIUM_TIME: {
                return this.getMediumTimeFormat();
            }
            case SHORT_TIME: {
                return this.getShortTimeFormat();
            }
        }
        throw new IllegalArgumentException("unknown date/time type " + (Object)((Object)type));
    }

    public String[] getAmPmStrings() {
        return this._amPmStrings;
    }

    private static String toDateTimeFormat(String dateFormat, String timeFormat) {
        return String.valueOf(dateFormat) + " " + timeFormat;
    }

    protected String getLongDateFormat() {
        return this._longDateFormat;
    }

    protected String getMediumDateFormat() {
        return MEDIUM_DATE_FORMAT;
    }

    protected String getMediumTimeFormat() {
        return MEDIUM_TIME_FORMAT;
    }

    protected String getShortTimeFormat() {
        return SHORT_TIME_FORMAT;
    }

    public static enum Type {
        DATE,
        TIME,
        DATE_TIME,
        TIME_12,
        TIME_24,
        DATE_TIME_12,
        DATE_TIME_24,
        GENERAL_DATE,
        LONG_DATE,
        MEDIUM_DATE,
        SHORT_DATE,
        LONG_TIME,
        MEDIUM_TIME,
        SHORT_TIME;


        public Type getDefaultType() {
            switch (this) {
                case DATE: 
                case LONG_DATE: 
                case MEDIUM_DATE: 
                case SHORT_DATE: {
                    return DATE;
                }
                case TIME: 
                case TIME_12: 
                case TIME_24: 
                case LONG_TIME: 
                case MEDIUM_TIME: 
                case SHORT_TIME: {
                    return TIME;
                }
                case DATE_TIME: 
                case DATE_TIME_12: 
                case DATE_TIME_24: 
                case GENERAL_DATE: {
                    return DATE_TIME;
                }
            }
            throw new RuntimeException("invalid type " + (Object)((Object)this));
        }

        public Value.Type getValueType() {
            switch (this) {
                case DATE: 
                case LONG_DATE: 
                case MEDIUM_DATE: 
                case SHORT_DATE: {
                    return Value.Type.DATE;
                }
                case TIME: 
                case TIME_12: 
                case TIME_24: 
                case LONG_TIME: 
                case MEDIUM_TIME: 
                case SHORT_TIME: {
                    return Value.Type.TIME;
                }
                case DATE_TIME: 
                case DATE_TIME_12: 
                case DATE_TIME_24: 
                case GENERAL_DATE: {
                    return Value.Type.DATE_TIME;
                }
            }
            throw new RuntimeException("invalid type " + (Object)((Object)this));
        }

        public boolean includesTime() {
            return !this.isDateOnly();
        }

        public boolean includesDate() {
            return !this.isTimeOnly();
        }

        public boolean isDateOnly() {
            switch (this) {
                case DATE: 
                case LONG_DATE: 
                case MEDIUM_DATE: 
                case SHORT_DATE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isTimeOnly() {
            switch (this) {
                case TIME: 
                case TIME_12: 
                case TIME_24: 
                case LONG_TIME: 
                case MEDIUM_TIME: 
                case SHORT_TIME: {
                    return true;
                }
            }
            return false;
        }
    }
}

