/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.JackcessException;
import com.healthmarketscience.jackcess.expr.EvalContext;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.Expression;
import com.healthmarketscience.jackcess.expr.Identifier;
import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.NumericConfig;
import com.healthmarketscience.jackcess.expr.TemporalConfig;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.DBEvalContext;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.expr.Expressionator;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.script.Bindings;

public abstract class BaseEvalContext
implements EvalContext {
    private static final Map<DataType, Value.Type> TYPE_MAP = new EnumMap<DataType, Value.Type>(DataType.class);
    private final DBEvalContext _dbCtx;
    private Expression _expr;

    static {
        TYPE_MAP.put(DataType.BOOLEAN, Value.Type.LONG);
        TYPE_MAP.put(DataType.BYTE, Value.Type.LONG);
        TYPE_MAP.put(DataType.INT, Value.Type.LONG);
        TYPE_MAP.put(DataType.LONG, Value.Type.LONG);
        TYPE_MAP.put(DataType.MONEY, Value.Type.DOUBLE);
        TYPE_MAP.put(DataType.FLOAT, Value.Type.DOUBLE);
        TYPE_MAP.put(DataType.DOUBLE, Value.Type.DOUBLE);
        TYPE_MAP.put(DataType.SHORT_DATE_TIME, Value.Type.DATE_TIME);
        TYPE_MAP.put(DataType.NUMERIC, Value.Type.BIG_DEC);
        TYPE_MAP.put(DataType.BIG_INT, Value.Type.BIG_DEC);
    }

    protected BaseEvalContext(DBEvalContext dbCtx) {
        this._dbCtx = dbCtx;
    }

    void setExpr(Expressionator.Type exprType, String exprStr) {
        this._expr = new RawExpr(exprType, exprStr);
    }

    protected DatabaseImpl getDatabase() {
        return this._dbCtx.getDatabase();
    }

    @Override
    public TemporalConfig getTemporalConfig() {
        return this._dbCtx.getTemporalConfig();
    }

    @Override
    public DateTimeFormatter createDateFormatter(String formatStr) {
        return this._dbCtx.createDateFormatter(formatStr);
    }

    @Override
    public ZoneId getZoneId() {
        return this._dbCtx.getZoneId();
    }

    @Override
    public NumericConfig getNumericConfig() {
        return this._dbCtx.getNumericConfig();
    }

    @Override
    public DecimalFormat createDecimalFormat(String formatStr) {
        return this._dbCtx.createDecimalFormat(formatStr);
    }

    @Override
    public float getRandom(Integer seed) {
        return this._dbCtx.getRandom(seed);
    }

    @Override
    public Value.Type getResultType() {
        return null;
    }

    @Override
    public Value getThisColumnValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getIdentifierValue(Identifier identifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings getBindings() {
        return this._dbCtx.getBindings();
    }

    @Override
    public Object get(String key) {
        return this._dbCtx.getBindings().get(key);
    }

    @Override
    public void put(String key, Object value) {
        this._dbCtx.getBindings().put(key, value);
    }

    public Object eval() throws IOException {
        try {
            return this._expr.eval(this);
        }
        catch (Exception e) {
            String msg = this.withErrorContext(e.getMessage());
            throw new JackcessException(msg, e);
        }
    }

    public void collectIdentifiers(Collection<Identifier> identifiers) {
        this._expr.collectIdentifiers(identifiers);
    }

    public String toString() {
        return this._expr.toString();
    }

    protected Value toValue(Object val, DataType dType) {
        try {
            val = ColumnImpl.toInternalValue(dType, val, this.getDatabase(), ColumnImpl.LDT_DATE_TIME_FACTORY);
            if (val == null) {
                return ValueSupport.NULL_VAL;
            }
            Value.Type vType = BaseEvalContext.toValueType(dType);
            switch (vType) {
                case STRING: {
                    return ValueSupport.toValue(val.toString());
                }
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    return ValueSupport.toValue(vType, (LocalDateTime)val);
                }
                case LONG: {
                    Integer i = val instanceof Integer ? ((Integer)val).intValue() : ((Number)val).intValue();
                    return ValueSupport.toValue(i);
                }
                case DOUBLE: {
                    Double d = val instanceof Double ? ((Double)val).doubleValue() : ((Number)val).doubleValue();
                    return ValueSupport.toValue(d);
                }
                case BIG_DEC: {
                    BigDecimal bd = ColumnImpl.toBigDecimal(val, this.getDatabase());
                    return ValueSupport.toValue(bd);
                }
            }
            throw new RuntimeException("Unexpected type " + (Object)((Object)vType));
        }
        catch (IOException e) {
            throw new EvalException("Failed converting value to type " + (Object)((Object)dType), e);
        }
    }

    public static Value.Type toValueType(DataType dType) {
        Value.Type type = TYPE_MAP.get((Object)dType);
        return type == null ? Value.Type.STRING : type;
    }

    protected abstract String withErrorContext(String var1);

    private class RawExpr
    implements Expression {
        private final Expressionator.Type _exprType;
        private final String _exprStr;

        private RawExpr(Expressionator.Type exprType, String exprStr) {
            this._exprType = exprType;
            this._exprStr = exprStr;
        }

        private Expression getExpr() {
            Expression expr;
            BaseEvalContext.this._expr = expr = Expressionator.parse(this._exprType, this._exprStr, BaseEvalContext.this.getResultType(), BaseEvalContext.this._dbCtx);
            return expr;
        }

        @Override
        public Object eval(EvalContext ctx) {
            return this.getExpr().eval(ctx);
        }

        @Override
        public String toDebugString(LocaleContext ctx) {
            return this.getExpr().toDebugString(ctx);
        }

        @Override
        public String toRawString() {
            return this._exprStr;
        }

        @Override
        public String toCleanString(LocaleContext ctx) {
            return this.getExpr().toCleanString(ctx);
        }

        @Override
        public boolean isConstant() {
            return this.getExpr().isConstant();
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this.getExpr().collectIdentifiers(identifiers);
        }

        public String toString() {
            return this.toRawString();
        }
    }
}

