/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.InvalidValueException;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.Identifier;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.ColEvalContext;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.InternalColumnValidator;
import com.healthmarketscience.jackcess.impl.expr.Expressionator;
import com.healthmarketscience.jackcess.util.ColumnValidator;
import java.io.IOException;

public class ColValidatorEvalContext
extends ColEvalContext {
    private String _helpStr;
    private Object _val;

    public ColValidatorEvalContext(ColumnImpl col) {
        super(col);
    }

    ColValidatorEvalContext setExpr(String exprStr, String helpStr) {
        this.setExpr(Expressionator.Type.FIELD_VALIDATOR, exprStr);
        this._helpStr = helpStr;
        return this;
    }

    ColumnValidator toColumnValidator(ColumnValidator delegate) {
        return new InternalColumnValidator(delegate){

            @Override
            protected Object internalValidate(Column col, Object val) throws IOException {
                return ColValidatorEvalContext.this.validate(val);
            }

            @Override
            protected void appendToString(StringBuilder sb) {
                sb.append("expression=").append(ColValidatorEvalContext.this);
            }
        };
    }

    private void reset() {
        this._val = null;
    }

    @Override
    public Value getThisColumnValue() {
        return this.toValue(this._val);
    }

    @Override
    public Value getIdentifierValue(Identifier identifier) {
        if (!this.getCol().isThisColumn(identifier)) {
            throw new EvalException("Cannot access other fields for " + identifier);
        }
        return this.getThisColumnValue();
    }

    private Object validate(Object val) throws IOException {
        try {
            this._val = val;
            Boolean result = (Boolean)this.eval();
            if (!result.booleanValue()) {
                String msg = this._helpStr != null ? this._helpStr : "Invalid column value '" + val + "'";
                throw new InvalidValueException(this.withErrorContext(msg));
            }
            Object object = val;
            return object;
        }
        finally {
            this.reset();
        }
    }
}

