/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.RowIdImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableScanCursor;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import com.healthmarketscience.jackcess.util.ErrorHandler;
import com.healthmarketscience.jackcess.util.IterableBuilder;
import com.healthmarketscience.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CursorImpl
implements Cursor {
    private static final Log LOG = LogFactory.getLog(CursorImpl.class);
    public static final boolean MOVE_FORWARD = true;
    public static final boolean MOVE_REVERSE = false;
    private final IdImpl _id;
    private final TableImpl _table;
    private final TableImpl.RowState _rowState;
    private final PositionImpl _firstPos;
    private final PositionImpl _lastPos;
    protected PositionImpl _prevPos;
    protected PositionImpl _curPos;
    protected ColumnMatcher _columnMatcher = SimpleColumnMatcher.INSTANCE;

    protected CursorImpl(IdImpl id, TableImpl table, PositionImpl firstPos, PositionImpl lastPos) {
        this._id = id;
        this._table = table;
        this._rowState = this._table.createRowState();
        this._firstPos = firstPos;
        this._lastPos = lastPos;
        this._curPos = firstPos;
        this._prevPos = firstPos;
    }

    public static CursorImpl createCursor(TableImpl table) {
        return new TableScanCursor(table);
    }

    public TableImpl.RowState getRowState() {
        return this._rowState;
    }

    @Override
    public IdImpl getId() {
        return this._id;
    }

    @Override
    public TableImpl getTable() {
        return this._table;
    }

    public JetFormat getFormat() {
        return this.getTable().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getTable().getPageChannel();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._rowState.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this._rowState.setErrorHandler(newErrorHandler);
    }

    @Override
    public ColumnMatcher getColumnMatcher() {
        return this._columnMatcher;
    }

    @Override
    public void setColumnMatcher(ColumnMatcher columnMatcher) {
        if (columnMatcher == null) {
            columnMatcher = this.getDefaultColumnMatcher();
        }
        this._columnMatcher = columnMatcher;
    }

    protected ColumnMatcher getDefaultColumnMatcher() {
        return SimpleColumnMatcher.INSTANCE;
    }

    @Override
    public SavepointImpl getSavepoint() {
        return new SavepointImpl(this._id, this._curPos, this._prevPos);
    }

    @Override
    public void restoreSavepoint(Cursor.Savepoint savepoint) throws IOException {
        this.restoreSavepoint((SavepointImpl)savepoint);
    }

    public void restoreSavepoint(SavepointImpl savepoint) throws IOException {
        if (!this._id.equals(savepoint.getCursorId())) {
            throw new IllegalArgumentException("Savepoint " + savepoint + " is not valid for this cursor with id " + this._id);
        }
        this.restorePosition(savepoint.getCurrentPosition(), savepoint.getPreviousPosition());
    }

    protected PositionImpl getFirstPosition() {
        return this._firstPos;
    }

    protected PositionImpl getLastPosition() {
        return this._lastPos;
    }

    @Override
    public void reset() {
        this.beforeFirst();
    }

    @Override
    public void beforeFirst() {
        this.reset(true);
    }

    @Override
    public void afterLast() {
        this.reset(false);
    }

    @Override
    public boolean isBeforeFirst() throws IOException {
        return this.isAtBeginning(true);
    }

    @Override
    public boolean isAfterLast() throws IOException {
        return this.isAtBeginning(false);
    }

    protected boolean isAtBeginning(boolean moveForward) throws IOException {
        if (this.getDirHandler(moveForward).getBeginningPosition().equals(this._curPos)) {
            return !this.recheckPosition(!moveForward);
        }
        return false;
    }

    @Override
    public boolean isCurrentRowDeleted() throws IOException {
        TableImpl.positionAtRowData(this._rowState, this._curPos.getRowId());
        return this._rowState.isDeleted();
    }

    protected void reset(boolean moveForward) {
        this._prevPos = this._curPos = this.getDirHandler(moveForward).getBeginningPosition();
        this._rowState.reset();
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowIterator(null, true, true);
    }

    @Override
    public IterableBuilder newIterable() {
        return new IterableBuilder(this);
    }

    public Iterator<Row> iterator(IterableBuilder iterBuilder) {
        switch (iterBuilder.getType()) {
            case SIMPLE: {
                return new RowIterator(iterBuilder.getColumnNames(), iterBuilder.isReset(), iterBuilder.isForward());
            }
            case COLUMN_MATCH: {
                Map.Entry matchPattern = (Map.Entry)iterBuilder.getMatchPattern();
                return new ColumnMatchIterator(iterBuilder.getColumnNames(), (ColumnImpl)matchPattern.getKey(), matchPattern.getValue(), iterBuilder.isReset(), iterBuilder.isForward(), iterBuilder.getColumnMatcher());
            }
            case ROW_MATCH: {
                Map matchPattern = (Map)iterBuilder.getMatchPattern();
                return new RowMatchIterator(iterBuilder.getColumnNames(), matchPattern, iterBuilder.isReset(), iterBuilder.isForward(), iterBuilder.getColumnMatcher());
            }
        }
        throw new RuntimeException("unknown match type " + (Object)((Object)iterBuilder.getType()));
    }

    @Override
    public void deleteCurrentRow() throws IOException {
        this._table.deleteRow(this._rowState, this._curPos.getRowId());
    }

    @Override
    public Object[] updateCurrentRow(Object ... row) throws IOException {
        return this._table.updateRow(this._rowState, this._curPos.getRowId(), row);
    }

    @Override
    public <M extends Map<String, Object>> M updateCurrentRowFromMap(M row) throws IOException {
        return this._table.updateRowFromMap(this._rowState, this._curPos.getRowId(), row);
    }

    @Override
    public Row getNextRow() throws IOException {
        return this.getNextRow(null);
    }

    @Override
    public Row getNextRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, true);
    }

    @Override
    public Row getPreviousRow() throws IOException {
        return this.getPreviousRow(null);
    }

    @Override
    public Row getPreviousRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, false);
    }

    private Row getAnotherRow(Collection<String> columnNames, boolean moveForward) throws IOException {
        if (this.moveToAnotherRow(moveForward)) {
            return this.getCurrentRow(columnNames);
        }
        return null;
    }

    @Override
    public boolean moveToNextRow() throws IOException {
        return this.moveToAnotherRow(true);
    }

    @Override
    public boolean moveToPreviousRow() throws IOException {
        return this.moveToAnotherRow(false);
    }

    protected boolean moveToAnotherRow(boolean moveForward) throws IOException {
        if (this._curPos.equals(this.getDirHandler(moveForward).getEndPosition())) {
            return this.recheckPosition(moveForward);
        }
        return this.moveToAnotherRowImpl(moveForward);
    }

    protected void restorePosition(PositionImpl curPos) throws IOException {
        this.restorePosition(curPos, this._curPos);
    }

    protected final void restorePosition(PositionImpl curPos, PositionImpl prevPos) throws IOException {
        if (!curPos.equals(this._curPos) || !prevPos.equals(this._prevPos)) {
            this.restorePositionImpl(curPos, prevPos);
        }
    }

    protected void restorePositionImpl(PositionImpl curPos, PositionImpl prevPos) throws IOException {
        this._prevPos = this._curPos;
        this._curPos = curPos;
        this._rowState.reset();
    }

    private boolean recheckPosition(boolean moveForward) throws IOException {
        if (this.isUpToDate()) {
            return false;
        }
        this.restorePosition(this._prevPos);
        return this.moveToAnotherRowImpl(moveForward);
    }

    private boolean moveToAnotherRowImpl(boolean moveForward) throws IOException {
        this._rowState.reset();
        this._prevPos = this._curPos;
        this._curPos = this.findAnotherPosition(this._rowState, this._curPos, moveForward);
        TableImpl.positionAtRowHeader(this._rowState, this._curPos.getRowId());
        return !this._curPos.equals(this.getDirHandler(moveForward).getEndPosition());
    }

    @Override
    public boolean findRow(RowId rowId) throws IOException {
        RowIdImpl rowIdImpl = (RowIdImpl)rowId;
        PositionImpl curPos = this._curPos;
        PositionImpl prevPos = this._prevPos;
        boolean found = false;
        try {
            this.reset(true);
            if (TableImpl.positionAtRowHeader(this._rowState, rowIdImpl) == null) {
                return false;
            }
            this.restorePosition(this.getRowPosition(rowIdImpl));
            if (!this.isCurrentRowValid()) {
                return false;
            }
            found = true;
            return true;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean findFirstRow(Column columnPattern, Object valuePattern) throws IOException {
        return this.findFirstRow((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean findFirstRow(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.findAnotherRow(columnPattern, valuePattern, true, true, this._columnMatcher, this.prepareSearchInfo(columnPattern, valuePattern));
    }

    @Override
    public boolean findNextRow(Column columnPattern, Object valuePattern) throws IOException {
        return this.findNextRow((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean findNextRow(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.findAnotherRow(columnPattern, valuePattern, false, true, this._columnMatcher, this.prepareSearchInfo(columnPattern, valuePattern));
    }

    protected boolean findAnotherRow(ColumnImpl columnPattern, Object valuePattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        PositionImpl curPos = this._curPos;
        PositionImpl prevPos = this._prevPos;
        boolean found = false;
        try {
            if (reset) {
                this.reset(moveForward);
            }
            boolean bl = found = this.findAnotherRowImpl(columnPattern, valuePattern, moveForward, columnMatcher, searchInfo);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean findFirstRow(Map<String, ?> rowPattern) throws IOException {
        return this.findAnotherRow(rowPattern, true, true, this._columnMatcher, this.prepareSearchInfo(rowPattern));
    }

    @Override
    public boolean findNextRow(Map<String, ?> rowPattern) throws IOException {
        return this.findAnotherRow(rowPattern, false, true, this._columnMatcher, this.prepareSearchInfo(rowPattern));
    }

    protected boolean findAnotherRow(Map<String, ?> rowPattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        PositionImpl curPos = this._curPos;
        PositionImpl prevPos = this._prevPos;
        boolean found = false;
        try {
            if (reset) {
                this.reset(moveForward);
            }
            boolean bl = found = this.findAnotherRowImpl(rowPattern, moveForward, columnMatcher, searchInfo);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean currentRowMatches(Column columnPattern, Object valuePattern) throws IOException {
        return this.currentRowMatches((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean currentRowMatches(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.currentRowMatchesImpl(columnPattern, valuePattern, this._columnMatcher);
    }

    protected boolean currentRowMatchesImpl(ColumnImpl columnPattern, Object valuePattern, ColumnMatcher columnMatcher) throws IOException {
        return this.currentRowMatchesPattern(columnPattern.getName(), valuePattern, columnMatcher, this.getCurrentRowValue(columnPattern));
    }

    @Override
    public boolean currentRowMatches(Map<String, ?> rowPattern) throws IOException {
        return this.currentRowMatchesImpl(rowPattern, this._columnMatcher);
    }

    protected boolean currentRowMatchesImpl(Map<String, ?> rowPattern, ColumnMatcher columnMatcher) throws IOException {
        Row row = this.getCurrentRow(rowPattern.keySet());
        if (rowPattern.size() != row.size()) {
            return false;
        }
        for (Map.Entry e : row.entrySet()) {
            String columnName = (String)e.getKey();
            if (this.currentRowMatchesPattern(columnName, rowPattern.get(columnName), columnMatcher, e.getValue())) continue;
            return false;
        }
        return true;
    }

    protected final boolean currentRowMatchesPattern(String columnPattern, Object valuePattern, ColumnMatcher columnMatcher, Object rowValue) {
        if (valuePattern instanceof Predicate) {
            return ((Predicate)valuePattern).test(rowValue);
        }
        return columnMatcher.matches(this.getTable(), columnPattern, valuePattern, rowValue);
    }

    protected boolean findAnotherRowImpl(ColumnImpl columnPattern, Object valuePattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        while (this.moveToAnotherRow(moveForward)) {
            if (this.currentRowMatchesImpl(columnPattern, valuePattern, columnMatcher)) {
                return true;
            }
            if (!this.keepSearching(columnMatcher, searchInfo)) break;
        }
        return false;
    }

    protected boolean findAnotherRowImpl(Map<String, ?> rowPattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        while (this.moveToAnotherRow(moveForward)) {
            if (this.currentRowMatchesImpl(rowPattern, columnMatcher)) {
                return true;
            }
            if (!this.keepSearching(columnMatcher, searchInfo)) break;
        }
        return false;
    }

    protected Object prepareSearchInfo(ColumnImpl columnPattern, Object valuePattern) {
        return null;
    }

    protected Object prepareSearchInfo(Map<String, ?> rowPattern) {
        return null;
    }

    protected boolean keepSearching(ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        return true;
    }

    @Override
    public int moveNextRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, true);
    }

    @Override
    public int movePreviousRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, false);
    }

    private int moveSomeRows(int numRows, boolean moveForward) throws IOException {
        int numMovedRows = 0;
        while (numMovedRows < numRows && this.moveToAnotherRow(moveForward)) {
            ++numMovedRows;
        }
        return numMovedRows;
    }

    @Override
    public Row getCurrentRow() throws IOException {
        return this.getCurrentRow(null);
    }

    @Override
    public Row getCurrentRow(Collection<String> columnNames) throws IOException {
        return this._table.getRow(this._rowState, this._curPos.getRowId(), columnNames);
    }

    @Override
    public Object getCurrentRowValue(Column column) throws IOException {
        return this.getCurrentRowValue((ColumnImpl)column);
    }

    public Object getCurrentRowValue(ColumnImpl column) throws IOException {
        return this._table.getRowValue(this._rowState, this._curPos.getRowId(), column);
    }

    @Override
    public void setCurrentRowValue(Column column, Object value) throws IOException {
        this.setCurrentRowValue((ColumnImpl)column, value);
    }

    public void setCurrentRowValue(ColumnImpl column, Object value) throws IOException {
        Object[] row = new Object[this._table.getColumnCount()];
        Arrays.fill(row, Column.KEEP_VALUE);
        column.setRowValue(row, value);
        this._table.updateRow(this._rowState, this._curPos.getRowId(), row);
    }

    protected boolean isUpToDate() {
        return this._rowState.isUpToDate();
    }

    protected boolean isCurrentRowValid() throws IOException {
        return this._curPos.getRowId().isValid() && !this.isCurrentRowDeleted() && !this.isBeforeFirst() && !this.isAfterLast();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " CurPosition " + this._curPos + ", PrevPosition " + this._prevPos;
    }

    protected abstract PositionImpl getRowPosition(RowIdImpl var1) throws IOException;

    protected abstract PositionImpl findAnotherPosition(TableImpl.RowState var1, PositionImpl var2, boolean var3) throws IOException;

    protected abstract DirHandler getDirHandler(boolean var1);

    protected abstract class BaseIterator
    implements Iterator<Row> {
        protected final Collection<String> _columnNames;
        protected final boolean _moveForward;
        protected final ColumnMatcher _colMatcher;
        protected Boolean _hasNext;
        protected boolean _validRow;

        protected BaseIterator(Collection<String> columnNames, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            this._columnNames = columnNames;
            this._moveForward = moveForward;
            this._colMatcher = columnMatcher != null ? columnMatcher : CursorImpl.this._columnMatcher;
            try {
                if (reset) {
                    CursorImpl.this.reset(this._moveForward);
                } else if (CursorImpl.this.isCurrentRowValid()) {
                    this._validRow = true;
                    this._hasNext = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this._hasNext == null) {
                try {
                    this._hasNext = this.findNext();
                    this._validRow = this._hasNext;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
            return this._hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Row rtn = CursorImpl.this.getCurrentRow(this._columnNames);
                this._hasNext = null;
                return rtn;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public void remove() {
            if (this._validRow) {
                try {
                    CursorImpl.this.deleteCurrentRow();
                    this._validRow = false;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            } else {
                throw new IllegalStateException("Not at valid row");
            }
        }

        protected abstract boolean findNext() throws IOException;
    }

    private final class ColumnMatchIterator
    extends BaseIterator {
        private final ColumnImpl _columnPattern;
        private final Object _valuePattern;
        private final Object _searchInfo;

        private ColumnMatchIterator(Collection<String> columnNames, ColumnImpl columnPattern, Object valuePattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            super(columnNames, reset, moveForward, columnMatcher);
            this._columnPattern = columnPattern;
            this._valuePattern = valuePattern;
            this._searchInfo = CursorImpl.this.prepareSearchInfo(columnPattern, valuePattern);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.findAnotherRow(this._columnPattern, this._valuePattern, false, this._moveForward, this._colMatcher, this._searchInfo);
        }
    }

    protected abstract class DirHandler {
        protected DirHandler() {
        }

        public abstract PositionImpl getBeginningPosition();

        public abstract PositionImpl getEndPosition();
    }

    protected static final class IdImpl
    implements Cursor.Id {
        private final int _tablePageNumber;
        private final int _indexNumber;

        protected IdImpl(TableImpl table, IndexImpl index) {
            this._tablePageNumber = table.getTableDefPageNumber();
            this._indexNumber = index != null ? index.getIndexNumber() : -1;
        }

        public int hashCode() {
            return this._tablePageNumber;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._tablePageNumber == ((IdImpl)o)._tablePageNumber && this._indexNumber == ((IdImpl)o)._indexNumber;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this._tablePageNumber + ":" + this._indexNumber;
        }
    }

    protected static abstract class PositionImpl
    implements Cursor.Position {
        protected PositionImpl() {
        }

        public final int hashCode() {
            return this.getRowId().hashCode();
        }

        public final boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.equalsImpl(o);
        }

        @Override
        public abstract RowIdImpl getRowId();

        protected abstract boolean equalsImpl(Object var1);
    }

    private final class RowIterator
    extends BaseIterator {
        private RowIterator(Collection<String> columnNames, boolean reset, boolean moveForward) {
            super(columnNames, reset, moveForward, null);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.moveToAnotherRow(this._moveForward);
        }
    }

    private final class RowMatchIterator
    extends BaseIterator {
        private final Map<String, ?> _rowPattern;
        private final Object _searchInfo;

        private RowMatchIterator(Collection<String> columnNames, Map<String, ?> rowPattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            super(columnNames, reset, moveForward, columnMatcher);
            this._rowPattern = rowPattern;
            this._searchInfo = CursorImpl.this.prepareSearchInfo(rowPattern);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.findAnotherRow(this._rowPattern, false, this._moveForward, this._colMatcher, this._searchInfo);
        }
    }

    protected static final class SavepointImpl
    implements Cursor.Savepoint {
        private final IdImpl _cursorId;
        private final PositionImpl _curPos;
        private final PositionImpl _prevPos;

        private SavepointImpl(IdImpl cursorId, PositionImpl curPos, PositionImpl prevPos) {
            this._cursorId = cursorId;
            this._curPos = curPos;
            this._prevPos = prevPos;
        }

        @Override
        public IdImpl getCursorId() {
            return this._cursorId;
        }

        @Override
        public PositionImpl getCurrentPosition() {
            return this._curPos;
        }

        private PositionImpl getPreviousPosition() {
            return this._prevPos;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this._cursorId + " CurPosition " + this._curPos + ", PrevPosition " + this._prevPos;
        }
    }
}

