/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CustomToStringStyle
extends StandardToStringStyle {
    private static final long serialVersionUID = 0L;
    private static final String ML_FIELD_SEP = String.valueOf(System.lineSeparator()) + "  ";
    private static final String IMPL_SUFFIX = "Impl";
    private static final int MAX_BYTE_DETAIL_LEN = 20;
    private static final Object IGNORE_ME = new Object();
    public static final CustomToStringStyle INSTANCE = new CustomToStringStyle(){
        private static final long serialVersionUID = 0L;
        {
            this.setContentStart("[");
            this.setFieldSeparator(ML_FIELD_SEP);
            this.setFieldSeparatorAtStart(true);
            this.setFieldNameValueSeparator(": ");
            this.setArraySeparator("," + ML_FIELD_SEP);
            this.setContentEnd(String.valueOf(System.lineSeparator()) + "]");
            this.setUseShortClassName(true);
        }
    };
    public static final CustomToStringStyle VALUE_INSTANCE = new CustomToStringStyle(){
        private static final long serialVersionUID = 0L;
        {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }
    };

    private CustomToStringStyle() {
    }

    public static ToStringBuilder builder(Object obj) {
        return new ToStringBuilder(obj, (ToStringStyle)INSTANCE);
    }

    public static ToStringBuilder valueBuilder(Object obj) {
        return new ToStringBuilder(obj, (ToStringStyle)VALUE_INSTANCE);
    }

    public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
        if (value == IGNORE_ME) {
            return;
        }
        super.append(buffer, fieldName, value, fullDetail);
    }

    protected void appendClassName(StringBuffer buffer, Object obj) {
        if (obj instanceof String) {
            buffer.append(obj);
        } else {
            super.appendClassName(buffer, obj);
        }
    }

    protected String getShortClassName(Class<?> clss) {
        int idx;
        String shortName = super.getShortClassName(clss);
        if (shortName.endsWith(IMPL_SUFFIX)) {
            shortName = shortName.substring(0, shortName.length() - IMPL_SUFFIX.length());
        }
        if ((idx = shortName.lastIndexOf(46)) >= 0) {
            shortName = shortName.substring(idx + 1);
        }
        return shortName;
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (value instanceof ByteBuffer) {
            CustomToStringStyle.appendDetail(buffer, (ByteBuffer)value);
        } else {
            buffer.append(CustomToStringStyle.indent(value));
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> value) {
        buffer.append("[");
        StringBuffer sb = new StringBuffer();
        Iterator<?> iter = value.iterator();
        if (iter.hasNext()) {
            if (this.isFieldSeparatorAtStart()) {
                this.appendFieldSeparator(sb);
            }
            this.appendValueDetail(sb, fieldName, iter.next());
        }
        while (iter.hasNext()) {
            sb.append(this.getArraySeparator());
            this.appendValueDetail(sb, fieldName, iter.next());
        }
        buffer.append(CustomToStringStyle.indent(sb));
        if (this.isFieldSeparatorAtStart()) {
            this.appendFieldSeparator(buffer);
        }
        buffer.append("]");
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> value) {
        Map.Entry<?, ?> e;
        buffer.append("{");
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<?, ?>> iter = value.entrySet().iterator();
        if (iter.hasNext()) {
            if (this.isFieldSeparatorAtStart()) {
                this.appendFieldSeparator(sb);
            }
            e = iter.next();
            sb.append(e.getKey()).append("=");
            this.appendValueDetail(sb, fieldName, e.getValue());
        }
        while (iter.hasNext()) {
            sb.append(this.getArraySeparator());
            e = iter.next();
            sb.append(e.getKey()).append("=");
            this.appendValueDetail(sb, fieldName, e.getValue());
        }
        buffer.append(CustomToStringStyle.indent(sb));
        if (this.isFieldSeparatorAtStart()) {
            this.appendFieldSeparator(buffer);
        }
        buffer.append("}");
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array) {
        CustomToStringStyle.appendDetail(buffer, PageChannel.wrap(array));
    }

    private void appendValueDetail(StringBuffer buffer, String fieldName, Object value) {
        if (value == null) {
            this.appendNullText(buffer, fieldName);
        } else {
            this.appendInternal(buffer, fieldName, value, true);
        }
    }

    private static void appendDetail(StringBuffer buffer, ByteBuffer bb) {
        int len = bb.remaining();
        buffer.append("(").append(len).append(") ");
        buffer.append(ByteUtil.toHexString(bb, bb.position(), Math.min(len, 20)));
        if (len > 20) {
            buffer.append(" ...");
        }
    }

    private static String indent(Object obj) {
        return obj != null ? obj.toString().replaceAll(System.lineSeparator(), ML_FIELD_SEP) : null;
    }

    public static Object ignoreNull(Object obj) {
        return obj != null ? obj : IGNORE_ME;
    }
}

