/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.GeneralLegacyIndexCodes;
import com.healthmarketscience.jackcess.impl.IndexData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class General97IndexCodes
extends GeneralLegacyIndexCodes {
    private static final String CODES_FILE = String.valueOf(DatabaseImpl.RESOURCE_PATH) + "index_codes_gen_97.txt";
    private static final String EXT_MAPPINGS_FILE = String.valueOf(DatabaseImpl.RESOURCE_PATH) + "index_mappings_ext_gen_97.txt";
    private static final char FIRST_MAP_CHAR = '\u0152';
    private static final char LAST_MAP_CHAR = '\u2122';
    private static final byte EXT_CODES_BOUNDS_NIBBLE = 0;
    static final General97IndexCodes GEN_97_INSTANCE = new General97IndexCodes();

    General97IndexCodes() {
    }

    @Override
    GeneralLegacyIndexCodes.CharHandler getCharHandler(char c) {
        if (c <= '\u00ff') {
            return Codes._values[c];
        }
        if (c < '\u0152' || c > '\u2122') {
            return IGNORED_CHAR_HANDLER;
        }
        int extOffset = General97IndexCodes.asUnsignedChar(c) - General97IndexCodes.asUnsignedChar('\u0152');
        return Codes._values[ExtMappings._values[extOffset]];
    }

    @Override
    void writeNonNullIndexTextValue(Object value, ByteUtil.ByteStream bout, boolean isAscending) throws IOException {
        String str = General97IndexCodes.toIndexCharSequence(value);
        int prevLength = bout.getLength();
        NibbleStream extraCodes = null;
        int sigCharCount = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            GeneralLegacyIndexCodes.CharHandler ch = this.getCharHandler(c);
            byte[] bytes = ch.getInlineBytes();
            if (bytes != null) {
                bout.write(bytes);
            }
            if (ch.getType() != GeneralLegacyIndexCodes.Type.SIMPLE) {
                if (ch.isSignificantChar()) {
                    ++sigCharCount;
                } else {
                    bytes = ch.getExtraBytes();
                    if (bytes != null) {
                        if (extraCodes == null) {
                            extraCodes = new NibbleStream(str.length());
                            extraCodes.writeNibble(0);
                        }
                        General97IndexCodes.writeExtraCodes(sigCharCount, bytes, extraCodes);
                        sigCharCount = 0;
                    }
                }
            }
            ++i;
        }
        if (extraCodes != null) {
            extraCodes.writeNibble(0);
            extraCodes.writeTo(bout);
        } else {
            bout.write(0);
        }
        if (!isAscending) {
            IndexData.flipBytes(bout.getBytes(), prevLength, bout.getLength() - prevLength);
        }
    }

    private static void writeExtraCodes(int numSigChars, byte[] bytes, NibbleStream extraCodes) {
        if (numSigChars > 0) {
            extraCodes.writeFillNibbles(numSigChars, (byte)2);
        }
        extraCodes.writeNibble(bytes[0]);
    }

    static short[] loadMappings(String mappingsFilePath, char firstChar, char lastChar) {
        int firstCharCode = General97IndexCodes.asUnsignedChar(firstChar);
        int numMappings = General97IndexCodes.asUnsignedChar(lastChar) - firstCharCode + 1;
        short[] values = new short[numMappings];
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(DatabaseImpl.getResourceAsStream(mappingsFilePath), "US-ASCII"));
                String mappingLine = null;
                while ((mappingLine = reader.readLine()) != null) {
                    if ((mappingLine = mappingLine.trim()).length() == 0) continue;
                    String[] mappings = mappingLine.split(",");
                    int fromCode = Integer.parseInt(mappings[0]);
                    int toCode = Integer.parseInt(mappings[1]);
                    values[fromCode - firstCharCode] = (short)toCode;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("failed loading index mappings file " + mappingsFilePath, e);
            }
        }
        catch (Throwable throwable) {
            ByteUtil.closeQuietly(reader);
            throw throwable;
        }
        ByteUtil.closeQuietly(reader);
        return values;
    }

    private static final class Codes {
        private static final GeneralLegacyIndexCodes.CharHandler[] _values = General97IndexCodes.loadCodes(CODES_FILE, '\u0000', '\u00ff');

        private Codes() {
        }
    }

    private static final class ExtMappings {
        private static final short[] _values = General97IndexCodes.loadMappings(EXT_MAPPINGS_FILE, '\u0152', '\u2122');

        private ExtMappings() {
        }
    }

    protected static final class NibbleStream
    extends ByteUtil.ByteStream {
        private int _nibbleLen;

        protected NibbleStream(int length) {
            super(length);
        }

        private boolean nextIsHi() {
            return this._nibbleLen % 2 == 0;
        }

        private static int asLowNibble(int b) {
            return b & 0xF;
        }

        private static int asHiNibble(int b) {
            return b << 4 & 0xF0;
        }

        private void writeLowNibble(int b) {
            int byteOff = this._nibbleLen / 2;
            this.setBits(byteOff, (byte)NibbleStream.asLowNibble(b));
        }

        public void writeNibble(int b) {
            if (this.nextIsHi()) {
                this.write(NibbleStream.asHiNibble(b));
            } else {
                this.writeLowNibble(b);
            }
            ++this._nibbleLen;
        }

        public void writeFillNibbles(int length, byte b) {
            int newNibbleLen = this._nibbleLen + length;
            this.ensureCapacity((newNibbleLen + 1) / 2);
            if (!this.nextIsHi()) {
                this.writeLowNibble(b);
                --length;
            }
            if (length > 1) {
                byte doubleB = (byte)(NibbleStream.asHiNibble(b) | NibbleStream.asLowNibble(b));
                do {
                    this.write(doubleB);
                } while ((length -= 2) > 1);
            }
            if (length == 1) {
                this.write(NibbleStream.asHiNibble(b));
            }
            this._nibbleLen = newNibbleLen;
        }
    }
}

