/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.ConstraintViolationException;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.RelationshipBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DBMutator;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.RelationshipImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableUpdater;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelationshipCreator
extends DBMutator {
    private static final int CASCADE_FLAGS = 12544;
    private static final byte IGNORED_PRIMARY_INDEX_FLAGS = 10;
    private static final byte IGNORED_SECONDARY_INDEX_FLAGS = 11;
    private TableImpl _primaryTable;
    private TableImpl _secondaryTable;
    private RelationshipBuilder _relationship;
    private List<ColumnImpl> _primaryCols;
    private List<ColumnImpl> _secondaryCols;
    private int _flags;
    private String _name;

    public RelationshipCreator(DatabaseImpl database) {
        super(database);
    }

    public String getName() {
        return this._name;
    }

    public TableImpl getPrimaryTable() {
        return this._primaryTable;
    }

    public TableImpl getSecondaryTable() {
        return this._secondaryTable;
    }

    public boolean hasReferentialIntegrity() {
        return this._relationship.hasReferentialIntegrity();
    }

    public RelationshipImpl createRelationshipImpl(String name) {
        this._name = name;
        RelationshipImpl newRel = new RelationshipImpl(name, this._primaryTable, this._secondaryTable, this._flags, this._primaryCols, this._secondaryCols);
        return newRel;
    }

    public RelationshipImpl createRelationship(RelationshipBuilder relationship) throws IOException {
        this._relationship = relationship;
        this._name = relationship.getName();
        this.validate();
        this._flags = this._relationship.getFlags();
        if (this.isOneToOne()) {
            this._flags |= 1;
        }
        this.getPageChannel().startExclusiveWrite();
        try {
            RelationshipImpl newRel = this.getDatabase().writeRelationship(this);
            if (this.hasReferentialIntegrity()) {
                this.addPrimaryIndex();
                this.addSecondaryIndex();
            }
            RelationshipImpl relationshipImpl = newRel;
            return relationshipImpl;
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    private void addPrimaryIndex() throws IOException {
        TableUpdater updater = new TableUpdater(this._primaryTable);
        updater.setForeignKey(this.createFKReference(true));
        updater.addIndex(this.createPrimaryIndex(), true, (byte)10, (byte)0);
    }

    private void addSecondaryIndex() throws IOException {
        TableUpdater updater = new TableUpdater(this._secondaryTable);
        updater.setForeignKey(this.createFKReference(false));
        updater.addIndex(this.createSecondaryIndex(), true, (byte)11, (byte)0);
    }

    private IndexImpl.ForeignKeyReference createFKReference(boolean isPrimary) {
        byte tableType = 0;
        int otherTableNum = 0;
        int otherIdxNum = 0;
        if (isPrimary) {
            tableType = 1;
            otherTableNum = this._secondaryTable.getTableDefPageNumber();
            otherIdxNum = this._secondaryTable.getLogicalIndexCount();
        } else {
            tableType = 2;
            otherTableNum = this._primaryTable.getTableDefPageNumber();
            otherIdxNum = this._primaryTable.getLogicalIndexCount() - 1;
        }
        boolean cascadeUpdates = (this._flags & 0x100) != 0;
        boolean cascadeDeletes = (this._flags & 0x1000) != 0;
        boolean cascadeNull = (this._flags & 0x2000) != 0;
        return new IndexImpl.ForeignKeyReference(tableType, otherIdxNum, otherTableNum, cascadeUpdates, cascadeDeletes, cascadeNull);
    }

    private void validate() throws IOException {
        this._primaryTable = this.getDatabase().getTable(this._relationship.getFromTable());
        this._secondaryTable = this.getDatabase().getTable(this._relationship.getToTable());
        if (this._primaryTable == null || this._secondaryTable == null) {
            throw new IllegalArgumentException(this.withErrorContext("Two valid tables are required in relationship"));
        }
        if (this._name != null) {
            DatabaseImpl.validateIdentifierName(this._name, this._primaryTable.getFormat().MAX_INDEX_NAME_LENGTH, "relationship");
        }
        this._primaryCols = RelationshipCreator.getColumns(this._primaryTable, this._relationship.getFromColumns());
        this._secondaryCols = RelationshipCreator.getColumns(this._secondaryTable, this._relationship.getToColumns());
        if (this._primaryCols == null || this._primaryCols.isEmpty() || this._secondaryCols == null || this._secondaryCols.isEmpty()) {
            throw new IllegalArgumentException(this.withErrorContext("Missing columns in relationship"));
        }
        if (this._primaryCols.size() != this._secondaryCols.size()) {
            throw new IllegalArgumentException(this.withErrorContext("Must have same number of columns on each side of relationship"));
        }
        int i = 0;
        while (i < this._primaryCols.size()) {
            ColumnImpl pcol = this._primaryCols.get(i);
            ColumnImpl scol = this._primaryCols.get(i);
            if (pcol.getType() != scol.getType()) {
                throw new IllegalArgumentException(this.withErrorContext("Matched columns must have the same data type"));
            }
            ++i;
        }
        if (!this.hasReferentialIntegrity()) {
            if ((this._relationship.getFlags() & 0x3100) != 0) {
                throw new IllegalArgumentException(this.withErrorContext("Cascade flags cannot be enabled if referential integrity is not enforced"));
            }
            return;
        }
        IndexImpl primaryIdx = RelationshipCreator.getUniqueIndex(this._primaryTable, this._primaryCols);
        if (primaryIdx == null) {
            throw new IllegalArgumentException(this.withErrorContext("Missing unique index on primary table required to enforce integrity"));
        }
        if (new HashSet<String>(RelationshipCreator.getColumnNames(this._primaryCols)).size() != this._primaryCols.size() || new HashSet<String>(RelationshipCreator.getColumnNames(this._secondaryCols)).size() != this._secondaryCols.size()) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot have duplicate columns in an integrity enforced relationship"));
        }
        IndexCursor primaryCursor = primaryIdx.newCursor().toIndexCursor();
        Object[] entryValues = new Object[this._secondaryCols.size()];
        for (Row row : this._secondaryTable.newCursor().toCursor().newIterable().addColumns(this._secondaryCols)) {
            boolean hasValues = false;
            int i2 = 0;
            while (i2 < this._secondaryCols.size()) {
                entryValues[i2] = this._secondaryCols.get(i2).getRowValue(row);
                hasValues = hasValues || entryValues[i2] != null;
                ++i2;
            }
            if (!hasValues || primaryCursor.findFirstRowByEntry(entryValues)) continue;
            throw new ConstraintViolationException(this.withErrorContext("Integrity constraint violation found for relationship"));
        }
    }

    private IndexBuilder createPrimaryIndex() {
        String name = this.createPrimaryIndexName();
        return RelationshipCreator.createIndex(name, this._primaryCols).setUnique().setType((byte)2);
    }

    private IndexBuilder createSecondaryIndex() {
        return RelationshipCreator.createIndex(this._name, this._secondaryCols).setType((byte)2);
    }

    private static IndexBuilder createIndex(String name, List<ColumnImpl> cols) {
        IndexBuilder idx = new IndexBuilder(name);
        for (ColumnImpl col : cols) {
            idx.addColumns(col.getName());
        }
        return idx;
    }

    private String createPrimaryIndexName() {
        Set<String> idxNames = TableUpdater.getIndexNames(this._primaryTable, null);
        String baseName = ".r";
        String suffix = "B";
        String idxName;
        while (idxNames.contains(DatabaseImpl.toLookupName(idxName = String.valueOf(baseName) + suffix))) {
            char c = (char)(suffix.charAt(0) + '\u0001');
            if (c == '[') {
                c = 'a';
            }
            suffix = "" + c;
        }
        return idxName;
    }

    private static List<ColumnImpl> getColumns(TableImpl table, List<String> colNames) {
        ArrayList<ColumnImpl> cols = new ArrayList<ColumnImpl>();
        for (String colName : colNames) {
            cols.add(table.getColumn(colName));
        }
        return cols;
    }

    private static List<String> getColumnNames(List<ColumnImpl> cols) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnImpl col : cols) {
            colNames.add(col.getName());
        }
        return colNames;
    }

    private boolean isOneToOne() {
        if (RelationshipCreator.getUniqueIndex(this._primaryTable, this._primaryCols) == null) {
            return false;
        }
        IndexImpl idx = RelationshipCreator.getUniqueIndex(this._secondaryTable, this._secondaryCols);
        return idx != null;
    }

    private static IndexImpl getUniqueIndex(TableImpl table, List<ColumnImpl> cols) {
        return table.findIndexForColumns(RelationshipCreator.getColumnNames(cols), TableImpl.IndexFeature.EXACT_UNIQUE_ONLY);
    }

    private static String getTableErrorContext(TableImpl table, List<ColumnImpl> cols, String tableName, Collection<String> colNames) {
        if (table != null) {
            tableName = table.getName();
        }
        if (cols != null) {
            colNames = RelationshipCreator.getColumnNames(cols);
        }
        return CustomToStringStyle.valueBuilder(tableName).append(null, colNames).toString();
    }

    private String withErrorContext(String msg) {
        return String.valueOf(msg) + "(Rel=" + RelationshipCreator.getTableErrorContext(this._primaryTable, this._primaryCols, this._relationship.getFromTable(), this._relationship.getFromColumns()) + " -> " + RelationshipCreator.getTableErrorContext(this._secondaryTable, this._secondaryCols, this._relationship.getToTable(), this._relationship.getToColumns()) + ")";
    }
}

