/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.RowId;
import java.io.Serializable;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class RowIdImpl
implements RowId,
Serializable {
    private static final long serialVersionUID = 20131014L;
    public static final int FIRST_PAGE_NUMBER = -1;
    public static final int LAST_PAGE_NUMBER = -2;
    public static final int INVALID_ROW_NUMBER = -1;
    public static final RowIdImpl FIRST_ROW_ID = new RowIdImpl(-1, -1);
    public static final RowIdImpl LAST_ROW_ID = new RowIdImpl(-2, -1);
    private final int _pageNumber;
    private final int _rowNumber;
    private final Type _type;

    public RowIdImpl(int pageNumber, int rowNumber) {
        this._pageNumber = pageNumber;
        this._rowNumber = rowNumber;
        this._type = this._pageNumber == -1 ? Type.ALWAYS_FIRST : (this._pageNumber == -2 ? Type.ALWAYS_LAST : Type.NORMAL);
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public int getRowNumber() {
        return this._rowNumber;
    }

    public boolean isValid() {
        return this.getRowNumber() >= 0 && this.getPageNumber() >= 0;
    }

    public Type getType() {
        return this._type;
    }

    @Override
    public int compareTo(RowId other) {
        return this.compareTo((RowIdImpl)other);
    }

    @Override
    public int compareTo(RowIdImpl other) {
        return new CompareToBuilder().append((Object)this.getType(), (Object)other.getType()).append(this.getPageNumber(), other.getPageNumber()).append(this.getRowNumber(), other.getRowNumber()).toComparison();
    }

    public int hashCode() {
        return this.getPageNumber() ^ this.getRowNumber();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getPageNumber() == ((RowIdImpl)o).getPageNumber() && this.getRowNumber() == ((RowIdImpl)o).getRowNumber();
    }

    public String toString() {
        return String.valueOf(this.getPageNumber()) + ":" + this.getRowNumber();
    }

    public static enum Type {
        ALWAYS_FIRST,
        NORMAL,
        ALWAYS_LAST;

    }
}

