/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.InvalidValueException;
import com.healthmarketscience.jackcess.impl.RowEvalContext;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.expr.Expressionator;
import java.io.IOException;

public class RowValidatorEvalContext
extends RowEvalContext {
    private final TableImpl _table;
    private String _helpStr;

    public RowValidatorEvalContext(TableImpl table) {
        super(table.getDatabase());
        this._table = table;
    }

    RowValidatorEvalContext setExpr(String exprStr, String helpStr) {
        this.setExpr(Expressionator.Type.RECORD_VALIDATOR, exprStr);
        this._helpStr = helpStr;
        return this;
    }

    @Override
    protected TableImpl getTable() {
        return this._table;
    }

    public void validate(Object[] row) throws IOException {
        try {
            this.setRow(row);
            Boolean result = (Boolean)this.eval();
            if (!result.booleanValue()) {
                String msg = this._helpStr != null ? this._helpStr : "Invalid row";
                throw new InvalidValueException(this.withErrorContext(msg));
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected String withErrorContext(String msg) {
        return this._table.withErrorContext(msg);
    }
}

