/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.CursorImpl;
import com.healthmarketscience.jackcess.impl.RowIdImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.UsageMap;
import java.io.IOException;

public class TableScanCursor
extends CursorImpl {
    private static final ScanPosition FIRST_SCAN_POSITION = new ScanPosition(RowIdImpl.FIRST_ROW_ID);
    private static final ScanPosition LAST_SCAN_POSITION = new ScanPosition(RowIdImpl.LAST_ROW_ID);
    private final ScanDirHandler _forwardDirHandler = new ForwardScanDirHandler();
    private final ScanDirHandler _reverseDirHandler = new ReverseScanDirHandler();
    private final UsageMap.PageCursor _ownedPagesCursor;

    public TableScanCursor(TableImpl table) {
        super(new CursorImpl.IdImpl(table, null), table, FIRST_SCAN_POSITION, LAST_SCAN_POSITION);
        this._ownedPagesCursor = table.getOwnedPagesCursor();
    }

    @Override
    protected ScanDirHandler getDirHandler(boolean moveForward) {
        return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
    }

    @Override
    protected boolean isUpToDate() {
        return super.isUpToDate() && this._ownedPagesCursor.isUpToDate();
    }

    @Override
    protected void reset(boolean moveForward) {
        this._ownedPagesCursor.reset(moveForward);
        super.reset(moveForward);
    }

    @Override
    protected void restorePositionImpl(CursorImpl.PositionImpl curPos, CursorImpl.PositionImpl prevPos) throws IOException {
        if (!(curPos instanceof ScanPosition) || !(prevPos instanceof ScanPosition)) {
            throw new IllegalArgumentException("Restored positions must be scan positions");
        }
        this._ownedPagesCursor.restorePosition(curPos.getRowId().getPageNumber(), prevPos.getRowId().getPageNumber());
        super.restorePositionImpl(curPos, prevPos);
    }

    @Override
    protected CursorImpl.PositionImpl getRowPosition(RowIdImpl rowId) throws IOException {
        return new ScanPosition(rowId);
    }

    @Override
    protected CursorImpl.PositionImpl findAnotherPosition(TableImpl.RowState rowState, CursorImpl.PositionImpl curPos, boolean moveForward) throws IOException {
        ScanDirHandler handler = this.getDirHandler(moveForward);
        RowIdImpl curRowId = curPos.getRowId();
        TableImpl.positionAtRowHeader(rowState, curRowId);
        int currentRowNumber = curRowId.getRowNumber();
        while (true) {
            currentRowNumber = handler.getAnotherRowNumber(currentRowNumber);
            curRowId = new RowIdImpl(curRowId.getPageNumber(), currentRowNumber);
            TableImpl.positionAtRowHeader(rowState, curRowId);
            if (!rowState.isValid()) {
                curRowId = new RowIdImpl(handler.getAnotherPageNumber(), -1);
                TableImpl.positionAtRowHeader(rowState, curRowId);
                if (!rowState.isHeaderPageNumberValid()) {
                    return handler.getEndPosition();
                }
                currentRowNumber = handler.getInitialRowNumber(rowState.getRowsOnHeaderPage());
                continue;
            }
            if (!rowState.isDeleted()) break;
        }
        return new ScanPosition(curRowId);
    }

    private final class ForwardScanDirHandler
    extends ScanDirHandler {
        private ForwardScanDirHandler() {
        }

        @Override
        public CursorImpl.PositionImpl getBeginningPosition() {
            return TableScanCursor.this.getFirstPosition();
        }

        @Override
        public CursorImpl.PositionImpl getEndPosition() {
            return TableScanCursor.this.getLastPosition();
        }

        @Override
        public int getAnotherRowNumber(int curRowNumber) {
            return curRowNumber + 1;
        }

        @Override
        public int getAnotherPageNumber() {
            return TableScanCursor.this._ownedPagesCursor.getNextPage();
        }

        @Override
        public int getInitialRowNumber(int rowsOnPage) {
            return -1;
        }
    }

    private final class ReverseScanDirHandler
    extends ScanDirHandler {
        private ReverseScanDirHandler() {
        }

        @Override
        public CursorImpl.PositionImpl getBeginningPosition() {
            return TableScanCursor.this.getLastPosition();
        }

        @Override
        public CursorImpl.PositionImpl getEndPosition() {
            return TableScanCursor.this.getFirstPosition();
        }

        @Override
        public int getAnotherRowNumber(int curRowNumber) {
            return curRowNumber - 1;
        }

        @Override
        public int getAnotherPageNumber() {
            return TableScanCursor.this._ownedPagesCursor.getPreviousPage();
        }

        @Override
        public int getInitialRowNumber(int rowsOnPage) {
            return rowsOnPage;
        }
    }

    private abstract class ScanDirHandler
    extends CursorImpl.DirHandler {
        private ScanDirHandler() {
        }

        public abstract int getAnotherRowNumber(int var1);

        public abstract int getAnotherPageNumber();

        public abstract int getInitialRowNumber(int var1);
    }

    private static final class ScanPosition
    extends CursorImpl.PositionImpl {
        private final RowIdImpl _rowId;

        private ScanPosition(RowIdImpl rowId) {
            this._rowId = rowId;
        }

        @Override
        public RowIdImpl getRowId() {
            return this._rowId;
        }

        @Override
        protected boolean equalsImpl(Object o) {
            return this.getRowId().equals(((ScanPosition)o).getRowId());
        }

        public String toString() {
            return "RowId = " + this.getRowId();
        }
    }
}

