/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TempBufferHolder;
import com.healthmarketscience.jackcess.impl.TempPageHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class UsageMap {
    public static final byte MAP_TYPE_INLINE = 0;
    public static final byte MAP_TYPE_REFERENCE = 1;
    private static final int INVALID_BIT_INDEX = -1;
    private final DatabaseImpl _database;
    private final int _tablePageNum;
    private int _startOffset;
    private final short _rowStart;
    private int _startPage;
    private int _endPage;
    private BitSet _pageNumbers = new BitSet();
    private final ByteBuffer _tableBuffer;
    private int _modCount;
    private Handler _handler;
    static final String MSG_PREFIX_UNRECOGNIZED_MAP = "Unrecognized map type: ";

    private UsageMap(DatabaseImpl database, ByteBuffer tableBuffer, int pageNum, short rowStart) throws IOException {
        this._database = database;
        this._tableBuffer = tableBuffer;
        this._tablePageNum = pageNum;
        this._rowStart = rowStart;
        this._tableBuffer.position(this._rowStart + this.getFormat().OFFSET_USAGE_MAP_START);
        this._startOffset = this._tableBuffer.position();
    }

    public DatabaseImpl getDatabase() {
        return this._database;
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    public static UsageMap read(DatabaseImpl database, ByteBuffer buf) throws IOException {
        byte umapRowNum = buf.get();
        int umapPageNum = ByteUtil.get3ByteInt(buf);
        return UsageMap.read(database, umapPageNum, umapRowNum, false);
    }

    static UsageMap read(DatabaseImpl database, int pageNum, int rowNum, boolean isGlobal) throws IOException {
        if (pageNum <= 0) {
            throw new IllegalStateException("Invalid usage map page number " + pageNum);
        }
        JetFormat format = database.getFormat();
        PageChannel pageChannel = database.getPageChannel();
        ByteBuffer tableBuffer = pageChannel.createPageBuffer();
        pageChannel.readPage(tableBuffer, pageNum);
        short rowStart = TableImpl.findRowStart(tableBuffer, rowNum, format);
        short rowEnd = TableImpl.findRowEnd(tableBuffer, rowNum, format);
        tableBuffer.limit(rowEnd);
        byte mapType = tableBuffer.get(rowStart);
        UsageMap rtn = new UsageMap(database, tableBuffer, pageNum, rowStart);
        rtn.initHandler(mapType, isGlobal);
        return rtn;
    }

    private void initHandler(byte mapType, boolean isGlobal) throws IOException {
        if (mapType == 0) {
            this._handler = isGlobal ? new GlobalInlineHandler() : new InlineHandler();
        } else if (mapType == 1) {
            this._handler = isGlobal ? new GlobalReferenceHandler() : new ReferenceHandler();
        } else {
            throw new IOException(MSG_PREFIX_UNRECOGNIZED_MAP + mapType);
        }
    }

    public PageCursor cursor() {
        return new PageCursor();
    }

    public int getPageCount() {
        return this._pageNumbers.cardinality();
    }

    protected short getRowStart() {
        return this._rowStart;
    }

    protected int getRowEnd() {
        return this.getTableBuffer().limit();
    }

    protected void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    protected int getStartOffset() {
        return this._startOffset;
    }

    protected ByteBuffer getTableBuffer() {
        return this._tableBuffer;
    }

    protected int getTablePageNumber() {
        return this._tablePageNum;
    }

    protected int getStartPage() {
        return this._startPage;
    }

    protected int getEndPage() {
        return this._endPage;
    }

    protected BitSet getPageNumbers() {
        return this._pageNumbers;
    }

    protected void setPageRange(int newStartPage, int newEndPage) {
        this._startPage = newStartPage;
        this._endPage = newEndPage;
    }

    protected boolean isPageWithinRange(int pageNumber) {
        return pageNumber >= this._startPage && pageNumber < this._endPage;
    }

    protected int getFirstPageNumber() {
        return this.bitIndexToPageNumber(this.getNextBitIndex(-1), -2);
    }

    protected int getNextPageNumber(int curPage) {
        return this.bitIndexToPageNumber(this.getNextBitIndex(this.pageNumberToBitIndex(curPage)), -2);
    }

    protected int getNextBitIndex(int curIndex) {
        return this._pageNumbers.nextSetBit(curIndex + 1);
    }

    protected int getLastPageNumber() {
        return this.bitIndexToPageNumber(this.getPrevBitIndex(this._pageNumbers.length()), -1);
    }

    protected int getPrevPageNumber(int curPage) {
        return this.bitIndexToPageNumber(this.getPrevBitIndex(this.pageNumberToBitIndex(curPage)), -1);
    }

    protected int getPrevBitIndex(int curIndex) {
        --curIndex;
        while (curIndex >= 0 && !this._pageNumbers.get(curIndex)) {
            --curIndex;
        }
        return curIndex;
    }

    protected int bitIndexToPageNumber(int bitIndex, int invalidPageNumber) {
        return bitIndex >= 0 ? this._startPage + bitIndex : invalidPageNumber;
    }

    protected int pageNumberToBitIndex(int pageNumber) {
        return pageNumber >= 0 ? pageNumber - this._startPage : -1;
    }

    protected void clearTableAndPages() {
        this._pageNumbers.clear();
        this._startPage = 0;
        this._endPage = 0;
        ++this._modCount;
        int tableStart = this.getRowStart() + 1;
        int tableEnd = this.getRowEnd();
        ByteUtil.clearRange(this._tableBuffer, tableStart, tableEnd);
    }

    protected void writeTable() throws IOException {
        this.getPageChannel().writePage(this._tableBuffer, this._tablePageNum, this._rowStart);
    }

    protected void processMap(ByteBuffer buffer, int bufferStartPage) {
        int byteCount = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b != 0) {
                int i = 0;
                while (i < 8) {
                    if ((b & 1 << i) != 0) {
                        int pageNumberOffset = byteCount * 8 + i + bufferStartPage;
                        int pageNumber = this.bitIndexToPageNumber(pageNumberOffset, -1);
                        if (!this.isPageWithinRange(pageNumber)) {
                            throw new IllegalStateException("found page number " + pageNumber + " in usage map outside of expected range " + this._startPage + " to " + this._endPage);
                        }
                        this._pageNumbers.set(pageNumberOffset);
                    }
                    ++i;
                }
            }
            ++byteCount;
        }
    }

    public boolean containsPageNumber(int pageNumber) {
        return this._handler.containsPageNumber(pageNumber);
    }

    public void addPageNumber(int pageNumber) throws IOException {
        ++this._modCount;
        this._handler.addOrRemovePageNumber(pageNumber, true, false);
    }

    public void removePageNumber(int pageNumber) throws IOException {
        this.removePageNumber(pageNumber, true);
    }

    private void removePageNumber(int pageNumber, boolean force) throws IOException {
        ++this._modCount;
        this._handler.addOrRemovePageNumber(pageNumber, false, force);
    }

    protected void updateMap(int absolutePageNumber, int bufferRelativePageNumber, ByteBuffer buffer, boolean add, boolean force) throws IOException {
        int offset = bufferRelativePageNumber / 8;
        int bitmask = 1 << bufferRelativePageNumber % 8;
        byte b = buffer.get(this._startOffset + offset);
        int pageNumberOffset = this.pageNumberToBitIndex(absolutePageNumber);
        boolean isOn = this._pageNumbers.get(pageNumberOffset);
        if (isOn == add && !force) {
            throw new IOException("Page number " + absolutePageNumber + " already " + (add ? "added to" : "removed from") + " usage map, expected range " + this._startPage + " to " + this._endPage);
        }
        if (add) {
            b = (byte)(b | bitmask);
            this._pageNumbers.set(pageNumberOffset);
        } else {
            b = (byte)(b & ~bitmask);
            this._pageNumbers.clear(pageNumberOffset);
        }
        buffer.put(this._startOffset + offset, b);
    }

    private void promoteInlineHandlerToReferenceHandler(int newPageNumber) throws IOException {
        int oldStartPage = this._startPage;
        BitSet oldPageNumbers = (BitSet)this._pageNumbers.clone();
        this.clearTableAndPages();
        this._tableBuffer.put((int)this.getRowStart(), (byte)1);
        this.writeTable();
        this._handler = new ReferenceHandler();
        this.reAddPages(oldStartPage, oldPageNumbers, newPageNumber);
    }

    private void reAddPages(int oldStartPage, BitSet oldPageNumbers, int newPageNumber) throws IOException {
        int i = oldPageNumbers.nextSetBit(0);
        while (i >= 0) {
            this.addPageNumber(oldStartPage + i);
            i = oldPageNumbers.nextSetBit(i + 1);
        }
        if (newPageNumber > -1) {
            this.addPageNumber(newPageNumber);
        }
    }

    public String toString() {
        int nextPage;
        ArrayList<String> ranges = new ArrayList<String>();
        PageCursor pCursor = this.cursor();
        int curRangeStart = Integer.MIN_VALUE;
        int prevPage = Integer.MIN_VALUE;
        while ((nextPage = pCursor.getNextPage()) >= 0) {
            if (nextPage != prevPage + 1) {
                if (prevPage >= 0) {
                    UsageMap.rangeToString(ranges, curRangeStart, prevPage);
                }
                curRangeStart = nextPage;
            }
            prevPage = nextPage;
        }
        if (prevPage >= 0) {
            UsageMap.rangeToString(ranges, curRangeStart, prevPage);
        }
        return CustomToStringStyle.valueBuilder(this._handler.getClass().getSimpleName()).append("range", (Object)("(" + this._startPage + "-" + this._endPage + ")")).append("pageNumbers", ranges).toString();
    }

    private static void rangeToString(List<String> ranges, int rangeStart, int rangeEnd) {
        if (rangeEnd > rangeStart) {
            ranges.add(String.valueOf(rangeStart) + "-" + rangeEnd);
        } else {
            ranges.add(String.valueOf(rangeStart));
        }
    }

    private class GlobalInlineHandler
    extends InlineHandler {
        private GlobalInlineHandler() throws IOException {
        }

        @Override
        public boolean containsPageNumber(int pageNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addOrRemovePageNumberOutsideRange(int pageNumber, boolean add, boolean force) throws IOException {
            if (!add) {
                int firstPage = UsageMap.this.getFirstPageNumber();
                int lastPage = UsageMap.this.getLastPageNumber();
                if (firstPage <= -1 || pageNumber > lastPage) {
                    this.moveToNewStartPageForRemove(firstPage, pageNumber);
                }
            }
        }

        private void moveToNewStartPageForRemove(int firstPage, int newPageNumber) throws IOException {
            int oldEndPage = UsageMap.this.getEndPage();
            int newStartPage = firstPage <= -1 ? newPageNumber : newPageNumber - this.getMaxInlinePages() / 2;
            this.moveToNewStartPage(newStartPage, -1);
            if (firstPage <= -1) {
                ByteUtil.fillRange(UsageMap.this._tableBuffer, this.getInlineDataStart(), this.getInlineDataEnd());
                UsageMap.this.writeTable();
                UsageMap.this.getPageNumbers().set(0, this.getMaxInlinePages());
            } else {
                int i = oldEndPage;
                while (i < UsageMap.this.getEndPage()) {
                    UsageMap.this.addPageNumber(i);
                    ++i;
                }
            }
            UsageMap.this.removePageNumber(newPageNumber, false);
        }
    }

    private class GlobalReferenceHandler
    extends ReferenceHandler {
        private boolean _allocatingPage;
        private Integer _pendingPage;

        private GlobalReferenceHandler() throws IOException {
        }

        @Override
        public boolean containsPageNumber(int pageNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addOrRemovePageNumber(int pageNumber, boolean add, boolean force) throws IOException {
            if (this._allocatingPage && !add) {
                if (this._pendingPage != null) {
                    throw new IllegalStateException("should only have single pending page");
                }
                this._pendingPage = pageNumber;
                return;
            }
            super.addOrRemovePageNumber(pageNumber, add, force);
            while (this._pendingPage != null) {
                int removedPageNumber = this._pendingPage;
                this._pendingPage = null;
                super.addOrRemovePageNumber(removedPageNumber, false, true);
            }
        }

        @Override
        protected ByteBuffer allocateNewUsageMapPage(int pageIndex) throws IOException {
            try {
                this._allocatingPage = true;
                ByteBuffer mapPageBuffer = super.allocateNewUsageMapPage(pageIndex);
                int dataStart = UsageMap.this.getFormat().OFFSET_USAGE_MAP_PAGE_DATA;
                ByteUtil.fillRange(mapPageBuffer, dataStart, UsageMap.this.getFormat().PAGE_SIZE - dataStart);
                int maxPagesPerUmapPage = this.getMaxPagesPerUsagePage();
                int firstNewPage = pageIndex * maxPagesPerUmapPage;
                int lastNewPage = firstNewPage + maxPagesPerUmapPage;
                UsageMap.this._pageNumbers.set(firstNewPage, lastNewPage);
                ByteBuffer byteBuffer = mapPageBuffer;
                return byteBuffer;
            }
            finally {
                this._allocatingPage = false;
            }
        }
    }

    private abstract class Handler {
        protected Handler() {
        }

        public boolean containsPageNumber(int pageNumber) {
            return UsageMap.this.isPageWithinRange(pageNumber) && UsageMap.this.getPageNumbers().get(UsageMap.this.pageNumberToBitIndex(pageNumber));
        }

        public abstract void addOrRemovePageNumber(int var1, boolean var2, boolean var3) throws IOException;
    }

    private class InlineHandler
    extends Handler {
        private final int _maxInlinePages = (this.getInlineDataEnd() - this.getInlineDataStart()) * 8;

        protected InlineHandler() throws IOException {
            int startPage = UsageMap.this.getTableBuffer().getInt(UsageMap.this.getRowStart() + 1);
            this.setInlinePageRange(startPage);
            UsageMap.this.processMap(UsageMap.this.getTableBuffer(), 0);
        }

        protected final int getMaxInlinePages() {
            return this._maxInlinePages;
        }

        protected final int getInlineDataStart() {
            return UsageMap.this.getRowStart() + UsageMap.this.getFormat().OFFSET_USAGE_MAP_START;
        }

        protected final int getInlineDataEnd() {
            return UsageMap.this.getRowEnd();
        }

        private void setInlinePageRange(int startPage) {
            UsageMap.this.setPageRange(startPage, startPage + this.getMaxInlinePages());
        }

        @Override
        public void addOrRemovePageNumber(int pageNumber, boolean add, boolean force) throws IOException {
            if (UsageMap.this.isPageWithinRange(pageNumber)) {
                int bufferRelativePageNumber = UsageMap.this.pageNumberToBitIndex(pageNumber);
                UsageMap.this.updateMap(pageNumber, bufferRelativePageNumber, UsageMap.this.getTableBuffer(), add, force);
                UsageMap.this.writeTable();
            } else {
                this.addOrRemovePageNumberOutsideRange(pageNumber, add, force);
            }
        }

        protected void addOrRemovePageNumberOutsideRange(int pageNumber, boolean add, boolean force) throws IOException {
            if (add) {
                int firstPage = UsageMap.this.getFirstPageNumber();
                int lastPage = UsageMap.this.getLastPageNumber();
                if (firstPage <= -1) {
                    firstPage = pageNumber;
                    lastPage = pageNumber;
                } else if (pageNumber > lastPage) {
                    lastPage = pageNumber;
                } else {
                    firstPage = pageNumber;
                }
                if (lastPage - firstPage + 1 < this.getMaxInlinePages()) {
                    this.moveToNewStartPage(firstPage, pageNumber);
                } else {
                    UsageMap.this.promoteInlineHandlerToReferenceHandler(pageNumber);
                }
            } else if (!force) {
                throw new IOException("Page number " + pageNumber + " already removed from usage map" + ", expected range " + UsageMap.this._startPage + " to " + UsageMap.this._endPage);
            }
        }

        protected final void moveToNewStartPage(int newStartPage, int newPageNumber) throws IOException {
            int oldStartPage = UsageMap.this.getStartPage();
            BitSet oldPageNumbers = (BitSet)UsageMap.this.getPageNumbers().clone();
            UsageMap.this.clearTableAndPages();
            ByteBuffer tableBuffer = UsageMap.this.getTableBuffer();
            tableBuffer.position(UsageMap.this.getRowStart() + 1);
            tableBuffer.putInt(newStartPage);
            UsageMap.this.writeTable();
            this.setInlinePageRange(newStartPage);
            UsageMap.this.reAddPages(oldStartPage, oldPageNumbers, newPageNumber);
        }
    }

    public final class PageCursor {
        private final DirHandler _forwardDirHandler = new ForwardDirHandler();
        private final DirHandler _reverseDirHandler = new ReverseDirHandler();
        private int _curPageNumber;
        private int _prevPageNumber;
        private int _lastModCount;

        private PageCursor() {
            this.reset();
        }

        public UsageMap getUsageMap() {
            return UsageMap.this;
        }

        private DirHandler getDirHandler(boolean moveForward) {
            return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
        }

        public boolean isUpToDate() {
            return UsageMap.this._modCount == this._lastModCount;
        }

        public int getNextPage() {
            return this.getAnotherPage(true);
        }

        public int getPreviousPage() {
            return this.getAnotherPage(false);
        }

        private int getAnotherPage(boolean moveForward) {
            DirHandler handler = this.getDirHandler(moveForward);
            if (this._curPageNumber == handler.getEndPageNumber()) {
                if (!this.isUpToDate()) {
                    this.restorePosition(this._prevPageNumber);
                } else {
                    return this._curPageNumber;
                }
            }
            this.checkForModification();
            this._prevPageNumber = this._curPageNumber;
            this._curPageNumber = handler.getAnotherPageNumber(this._curPageNumber);
            return this._curPageNumber;
        }

        public void reset() {
            this.beforeFirst();
        }

        public void beforeFirst() {
            this.reset(true);
        }

        public void afterLast() {
            this.reset(false);
        }

        protected void reset(boolean moveForward) {
            this._prevPageNumber = this._curPageNumber = this.getDirHandler(moveForward).getBeginningPageNumber();
            this._lastModCount = UsageMap.this._modCount;
        }

        private void restorePosition(int curPageNumber) {
            this.restorePosition(curPageNumber, this._curPageNumber);
        }

        protected void restorePosition(int curPageNumber, int prevPageNumber) {
            if (curPageNumber != this._curPageNumber || prevPageNumber != this._prevPageNumber) {
                this._prevPageNumber = this.updatePosition(prevPageNumber);
                this._curPageNumber = this.updatePosition(curPageNumber);
                this._lastModCount = UsageMap.this._modCount;
            } else {
                this.checkForModification();
            }
        }

        private void checkForModification() {
            if (!this.isUpToDate()) {
                this._prevPageNumber = this.updatePosition(this._prevPageNumber);
                this._curPageNumber = this.updatePosition(this._curPageNumber);
                this._lastModCount = UsageMap.this._modCount;
            }
        }

        private int updatePosition(int pageNumber) {
            if (pageNumber < UsageMap.this.getFirstPageNumber()) {
                pageNumber = -1;
            } else if (pageNumber > UsageMap.this.getLastPageNumber()) {
                pageNumber = -2;
            }
            return pageNumber;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " CurPosition " + this._curPageNumber + ", PrevPosition " + this._prevPageNumber;
        }

        private abstract class DirHandler {
            private DirHandler() {
            }

            public abstract int getAnotherPageNumber(int var1);

            public abstract int getBeginningPageNumber();

            public abstract int getEndPageNumber();
        }

        private final class ForwardDirHandler
        extends DirHandler {
            private ForwardDirHandler() {
            }

            @Override
            public int getAnotherPageNumber(int curPageNumber) {
                if (curPageNumber == this.getBeginningPageNumber()) {
                    return UsageMap.this.getFirstPageNumber();
                }
                return UsageMap.this.getNextPageNumber(curPageNumber);
            }

            @Override
            public int getBeginningPageNumber() {
                return -1;
            }

            @Override
            public int getEndPageNumber() {
                return -2;
            }
        }

        private final class ReverseDirHandler
        extends DirHandler {
            private ReverseDirHandler() {
            }

            @Override
            public int getAnotherPageNumber(int curPageNumber) {
                if (curPageNumber == this.getBeginningPageNumber()) {
                    return UsageMap.this.getLastPageNumber();
                }
                return UsageMap.this.getPrevPageNumber(curPageNumber);
            }

            @Override
            public int getBeginningPageNumber() {
                return -2;
            }

            @Override
            public int getEndPageNumber() {
                return -1;
            }
        }
    }

    private class ReferenceHandler
    extends Handler {
        private final TempPageHolder _mapPageHolder = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
        private final int _maxPagesPerUsageMapPage;

        private ReferenceHandler() throws IOException {
            this._maxPagesPerUsageMapPage = (UsageMap.this.getFormat().PAGE_SIZE - UsageMap.this.getFormat().OFFSET_USAGE_MAP_PAGE_DATA) * 8;
            int numUsagePages = (UsageMap.this.getRowEnd() - UsageMap.this.getRowStart() - 1) / 4;
            UsageMap.this.setStartOffset(UsageMap.this.getFormat().OFFSET_USAGE_MAP_PAGE_DATA);
            UsageMap.this.setPageRange(0, numUsagePages * this._maxPagesPerUsageMapPage);
            int i = 0;
            while (i < numUsagePages) {
                int mapPageNum = UsageMap.this.getTableBuffer().getInt(this.calculateMapPagePointerOffset(i));
                if (mapPageNum > 0) {
                    ByteBuffer mapPageBuffer = this._mapPageHolder.setPage(UsageMap.this.getPageChannel(), mapPageNum);
                    byte pageType = mapPageBuffer.get();
                    if (pageType != 5) {
                        throw new IOException("Looking for usage map at page " + mapPageNum + ", but page type is " + pageType);
                    }
                    mapPageBuffer.position(UsageMap.this.getFormat().OFFSET_USAGE_MAP_PAGE_DATA);
                    UsageMap.this.processMap(mapPageBuffer, this._maxPagesPerUsageMapPage * i);
                }
                ++i;
            }
        }

        protected final int getMaxPagesPerUsagePage() {
            return this._maxPagesPerUsageMapPage;
        }

        @Override
        public void addOrRemovePageNumber(int pageNumber, boolean add, boolean force) throws IOException {
            if (!UsageMap.this.isPageWithinRange(pageNumber)) {
                if (force) {
                    return;
                }
                throw new IOException("Page number " + pageNumber + " is out of supported range");
            }
            int pageIndex = pageNumber / this.getMaxPagesPerUsagePage();
            int mapPageNum = UsageMap.this.getTableBuffer().getInt(this.calculateMapPagePointerOffset(pageIndex));
            ByteBuffer mapPageBuffer = null;
            if (mapPageNum > 0) {
                mapPageBuffer = this._mapPageHolder.setPage(UsageMap.this.getPageChannel(), mapPageNum);
            } else {
                mapPageBuffer = this.createNewUsageMapPage(pageIndex);
                mapPageNum = this._mapPageHolder.getPageNumber();
            }
            UsageMap.this.updateMap(pageNumber, pageNumber - this.getMaxPagesPerUsagePage() * pageIndex, mapPageBuffer, add, force);
            UsageMap.this.getPageChannel().writePage(mapPageBuffer, mapPageNum);
        }

        private ByteBuffer createNewUsageMapPage(int pageIndex) throws IOException {
            ByteBuffer mapPageBuffer = this.allocateNewUsageMapPage(pageIndex);
            int mapPageNum = this._mapPageHolder.getPageNumber();
            UsageMap.this.getTableBuffer().putInt(this.calculateMapPagePointerOffset(pageIndex), mapPageNum);
            UsageMap.this.writeTable();
            return mapPageBuffer;
        }

        private int calculateMapPagePointerOffset(int pageIndex) {
            return UsageMap.this.getRowStart() + UsageMap.this.getFormat().OFFSET_REFERENCE_MAP_PAGE_NUMBERS + pageIndex * 4;
        }

        protected ByteBuffer allocateNewUsageMapPage(int pageIndex) throws IOException {
            ByteBuffer mapPageBuffer = this._mapPageHolder.setNewPage(UsageMap.this.getPageChannel());
            mapPageBuffer.put((byte)5);
            mapPageBuffer.put((byte)1);
            mapPageBuffer.putShort((short)0);
            return mapPageBuffer;
        }
    }
}

