/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.EvalContext;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.Function;
import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.DefaultDateFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultFunctions;
import com.healthmarketscience.jackcess.impl.expr.FormatUtil;
import com.healthmarketscience.jackcess.impl.expr.FunctionSupport;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import org.apache.commons.lang3.text.WordUtils;

public class DefaultTextFunctions {
    private static final int STR_CONV_MASK = 3;
    public static final Function ASC = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Asc"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            int len = str.length();
            if (len == 0) {
                throw new EvalException("No characters in string");
            }
            char lv = str.charAt(0);
            if (lv < '\u0000' || lv > '\u00ff') {
                throw new EvalException("Character code '" + lv + "' out of range ");
            }
            return ValueSupport.toValue(lv);
        }
    });
    public static final Function ASCW = DefaultFunctions.registerFunc(new FunctionSupport.Func1("AscW"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            int len = str.length();
            if (len == 0) {
                throw new EvalException("No characters in string");
            }
            char lv = str.charAt(0);
            return ValueSupport.toValue(lv);
        }
    });
    public static final Function CHR = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Chr"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            int lv = param1.getAsLongInt(ctx);
            if (lv < 0 || lv > 255) {
                throw new EvalException("Character code '" + lv + "' out of range ");
            }
            char[] cs = Character.toChars(lv);
            return ValueSupport.toValue(new String(cs));
        }
    });
    public static final Function CHRW = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("ChrW"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            int lv = param1.getAsLongInt(ctx);
            char[] cs = Character.toChars(lv);
            return ValueSupport.toValue(new String(cs));
        }
    });
    public static final Function STR = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Str"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            BigDecimal bd = param1.getAsBigDecimal(ctx);
            String str = bd.toPlainString();
            if (bd.compareTo(BigDecimal.ZERO) >= 0) {
                str = " " + str;
            }
            return ValueSupport.toValue(str);
        }
    });
    public static final Function INSTR = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("InStr", 2, 4){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value param2;
            int idx = 0;
            int start = 0;
            if (params.length > 2) {
                start = params[0].getAsLongInt(ctx) - 1;
            }
            int n = ++idx;
            ++idx;
            Value param1 = params[n];
            if (param1.isNull()) {
                return param1;
            }
            String s1 = param1.getAsString(ctx);
            int s1Len = s1.length();
            if (s1Len == 0) {
                return ValueSupport.ZERO_VAL;
            }
            if ((param2 = params[idx++]).isNull()) {
                return param2;
            }
            String s2 = param2.getAsString(ctx);
            int s2Len = s2.length();
            if (s2Len == 0) {
                return ValueSupport.toValue(start + 1);
            }
            boolean ignoreCase = DefaultTextFunctions.getIgnoreCase(ctx, params, 3);
            int end = s1Len - s2Len;
            while (start < end) {
                if (s1.regionMatches(ignoreCase, start, s2, 0, s2Len)) {
                    return ValueSupport.toValue(start + 1);
                }
                ++start;
            }
            return ValueSupport.ZERO_VAL;
        }
    });
    public static final Function INSTRREV = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("InStrRev", 2, 4){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value param1 = params[0];
            if (param1.isNull()) {
                return param1;
            }
            String s1 = param1.getAsString(ctx);
            int s1Len = s1.length();
            if (s1Len == 0) {
                return ValueSupport.ZERO_VAL;
            }
            Value param2 = params[1];
            if (param2.isNull()) {
                return param2;
            }
            String s2 = param2.getAsString(ctx);
            int s2Len = s2.length();
            int start = s1Len - 1;
            if (s2Len == 0) {
                return ValueSupport.toValue(start + 1);
            }
            if (params.length > 2) {
                start = params[2].getAsLongInt(ctx);
                if (start == -1) {
                    start = s1Len;
                }
                --start;
            }
            boolean ignoreCase = DefaultTextFunctions.getIgnoreCase(ctx, params, 3);
            start = Math.min(s1Len - s2Len, start - s2Len + 1);
            while (start >= 0) {
                if (s1.regionMatches(ignoreCase, start, s2, 0, s2Len)) {
                    return ValueSupport.toValue(start + 1);
                }
                --start;
            }
            return ValueSupport.ZERO_VAL;
        }
    });
    public static final Function LCASE = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("LCase"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(str.toLowerCase());
        }
    });
    public static final Function UCASE = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("UCase"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(str.toUpperCase());
        }
    });
    public static final Function LEFT = DefaultFunctions.registerStringFunc(new FunctionSupport.Func2("Left"){

        @Override
        protected Value eval2(EvalContext ctx, Value param1, Value param2) {
            if (param1.isNull()) {
                return param1;
            }
            String str = param1.getAsString(ctx);
            int len = Math.min(str.length(), param2.getAsLongInt(ctx));
            return ValueSupport.toValue(str.substring(0, len));
        }
    });
    public static final Function RIGHT = DefaultFunctions.registerStringFunc(new FunctionSupport.Func2("Right"){

        @Override
        protected Value eval2(EvalContext ctx, Value param1, Value param2) {
            if (param1.isNull()) {
                return param1;
            }
            String str = param1.getAsString(ctx);
            int strLen = str.length();
            int len = Math.min(strLen, param2.getAsLongInt(ctx));
            return ValueSupport.toValue(str.substring(strLen - len, strLen));
        }
    });
    public static final Function MID = DefaultFunctions.registerStringFunc(new FunctionSupport.FuncVar("Mid", 2, 3){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value param1 = params[0];
            if (param1.isNull()) {
                return param1;
            }
            String str = param1.getAsString(ctx);
            int strLen = str.length();
            int start = Math.min(strLen, params[1].getAsLongInt(ctx) - 1);
            int len = Math.min(params.length > 2 ? params[2].getAsLongInt(ctx) : strLen, strLen - start);
            return ValueSupport.toValue(str.substring(start, start + len));
        }
    });
    public static final Function LEN = DefaultFunctions.registerFunc(new FunctionSupport.Func1NullIsNull("Len"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(str.length());
        }
    });
    public static final Function LTRIM = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("LTrim"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(DefaultTextFunctions.trim(str, true, false));
        }
    });
    public static final Function RTRIM = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("RTrim"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(DefaultTextFunctions.trim(str, false, true));
        }
    });
    public static final Function TRIM = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1NullIsNull("Trim"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(DefaultTextFunctions.trim(str, true, true));
        }
    });
    public static final Function REPLACE = DefaultFunctions.registerStringFunc(new FunctionSupport.FuncVar("Replace", 3, 6){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            String str = params[0].getAsString(ctx);
            String searchStr = params[1].getAsString(ctx);
            String replStr = params[2].getAsString(ctx);
            int strLen = str.length();
            int start = FunctionSupport.getOptionalIntParam(ctx, params, 3, 1) - 1;
            int count = FunctionSupport.getOptionalIntParam(ctx, params, 4, -1);
            boolean ignoreCase = DefaultTextFunctions.getIgnoreCase(ctx, params, 5);
            if (start >= strLen) {
                return ValueSupport.EMPTY_STR_VAL;
            }
            int searchLen = searchStr.length();
            if (searchLen == 0 || count == 0) {
                String result = str;
                if (start > 0) {
                    result = str.substring(start);
                }
                return ValueSupport.toValue(result);
            }
            if (count < 0) {
                count = strLen;
            }
            StringBuilder result = new StringBuilder(strLen);
            int matchCount = 0;
            int i = start;
            while (i < strLen) {
                if (matchCount < count && str.regionMatches(ignoreCase, i, searchStr, 0, searchLen)) {
                    result.append(replStr);
                    ++matchCount;
                    i += searchLen - 1;
                } else {
                    result.append(str.charAt(i));
                }
                ++i;
            }
            return ValueSupport.toValue(result.toString());
        }
    });
    public static final Function SPACE = DefaultFunctions.registerStringFunc(new FunctionSupport.Func1("Space"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            int lv = param1.getAsLongInt(ctx);
            return ValueSupport.toValue(DefaultTextFunctions.nchars(lv, ' '));
        }
    });
    public static final Function STRCOMP = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("StrComp", 2, 3){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            int cmp;
            Value param1 = params[0];
            Value param2 = params[1];
            if (param1.isNull() || param2.isNull()) {
                return ValueSupport.NULL_VAL;
            }
            String s1 = param1.getAsString(ctx);
            String s2 = param2.getAsString(ctx);
            boolean ignoreCase = DefaultTextFunctions.getIgnoreCase(ctx, params, 2);
            int n = cmp = ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
            return cmp < 0 ? ValueSupport.NEG_ONE_VAL : (cmp > 0 ? ValueSupport.ONE_VAL : ValueSupport.ZERO_VAL);
        }
    });
    public static final Function STRCONV = DefaultFunctions.registerStringFunc(new FunctionSupport.FuncVar("StrConv", 2, 3){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value param1 = params[0];
            if (param1.isNull()) {
                return ValueSupport.NULL_VAL;
            }
            String str = param1.getAsString(ctx);
            int conversion = params[1].getAsLongInt(ctx);
            int caseConv = 3 & conversion;
            int charConv = 0xFFFFFFFC & conversion;
            switch (caseConv) {
                case 1: {
                    str = str.toUpperCase();
                    break;
                }
                case 2: {
                    str = str.toLowerCase();
                    break;
                }
                case 3: {
                    str = WordUtils.capitalize((String)str.toLowerCase());
                }
            }
            if (charConv != 0 && charConv != 64) {
                throw new EvalException("Unsupported character conversion " + charConv);
            }
            return ValueSupport.toValue(str);
        }
    });
    public static final Function STRING = DefaultFunctions.registerStringFunc(new FunctionSupport.Func2("String"){

        @Override
        protected Value eval2(EvalContext ctx, Value param1, Value param2) {
            if (param1.isNull() || param2.isNull()) {
                return ValueSupport.NULL_VAL;
            }
            int lv = param1.getAsLongInt(ctx);
            char c = (char)(param2.getAsString(ctx).charAt(0) % 256);
            return ValueSupport.toValue(DefaultTextFunctions.nchars(lv, c));
        }
    });
    public static final Function STRREVERSE = DefaultFunctions.registerFunc(new FunctionSupport.Func1("StrReverse"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            String str = param1.getAsString(ctx);
            return ValueSupport.toValue(new StringBuilder(str).reverse().toString());
        }
    });
    public static final Function FORMAT = DefaultFunctions.registerStringFunc(new FunctionSupport.FuncVar("Format", 1, 4){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value expr = params[0];
            if (params.length < 2) {
                if (expr.isNull()) {
                    return ValueSupport.NULL_VAL;
                }
                return ValueSupport.toValue(expr.getAsString(ctx));
            }
            String fmtStr = params[1].getAsString(ctx);
            int firstDay = DefaultDateFunctions.getFirstDayParam(ctx, params, 2);
            int firstWeekType = DefaultDateFunctions.getFirstWeekTypeParam(ctx, params, 3);
            return FormatUtil.format(ctx, expr, fmtStr, firstDay, firstWeekType);
        }
    });

    private DefaultTextFunctions() {
    }

    static void init() {
    }

    private static String nchars(int num, char c) {
        StringBuilder sb = new StringBuilder(num);
        DefaultTextFunctions.nchars(sb, num, c);
        return sb.toString();
    }

    static void nchars(StringBuilder sb, int num, char c) {
        int i = 0;
        while (i < num) {
            sb.append(c);
            ++i;
        }
    }

    private static String trim(String str, boolean doLeft, boolean doRight) {
        int start = 0;
        int end = str.length();
        if (doLeft) {
            while (start < end && str.charAt(start) == ' ') {
                ++start;
            }
        }
        if (doRight) {
            while (start < end && str.charAt(end - 1) == ' ') {
                --end;
            }
        }
        return str.substring(start, end);
    }

    private static boolean getIgnoreCase(EvalContext ctx, Value[] params, int idx) {
        boolean ignoreCase = true;
        if (params.length > idx) {
            ignoreCase = DefaultTextFunctions.doIgnoreCase(ctx, params[idx]);
        }
        return ignoreCase;
    }

    private static boolean doIgnoreCase(LocaleContext ctx, Value paramCmp) {
        int cmpType = paramCmp.getAsLongInt(ctx);
        switch (cmpType) {
            case -1: 
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new EvalException("Unsupported compare type " + cmpType);
    }
}

