/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.ParseException;
import com.healthmarketscience.jackcess.expr.TemporalConfig;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.expr.Expressionator;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class ExpressionTokenizer {
    private static final int EOF = -1;
    static final char QUOTED_STR_CHAR = '\"';
    private static final char SINGLE_QUOTED_STR_CHAR = '\'';
    private static final char OBJ_NAME_START_CHAR = '[';
    private static final char OBJ_NAME_END_CHAR = ']';
    private static final char DATE_LIT_QUOTE_CHAR = '#';
    private static final char EQUALS_CHAR = '=';
    private static final byte IS_OP_FLAG = 1;
    private static final byte IS_COMP_FLAG = 2;
    private static final byte IS_DELIM_FLAG = 4;
    private static final byte IS_SPACE_FLAG = 8;
    private static final byte IS_QUOTE_FLAG = 16;
    private static final byte[] CHAR_FLAGS = new byte[128];
    private static final Set<String> TWO_CHAR_COMP_OPS = new HashSet<String>(Arrays.asList("<=", ">=", "<>"));

    static {
        ExpressionTokenizer.setCharFlag((byte)1, '+', '-', '*', '/', '\\', '^', '&');
        ExpressionTokenizer.setCharFlag((byte)2, '<', '>', '=');
        ExpressionTokenizer.setCharFlag((byte)4, '.', '!', ',', '(', ')');
        ExpressionTokenizer.setCharFlag((byte)8, ' ', '\n', '\r', '\t');
        ExpressionTokenizer.setCharFlag((byte)16, '\"', '#', '[', ']', '\'');
    }

    private ExpressionTokenizer() {
    }

    static List<Token> tokenize(Expressionator.Type exprType, String exprStr, Expressionator.ParseContext context) {
        if (exprStr != null) {
            exprStr = exprStr.trim();
        }
        if (StringUtils.isEmpty((CharSequence)exprStr)) {
            return null;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        ExprBuf buf = new ExprBuf(exprStr, context);
        block12: while (buf.hasNext()) {
            Token numLit;
            char c = buf.next();
            byte charFlag = ExpressionTokenizer.getCharFlag(c);
            if (charFlag != 0) {
                switch (charFlag) {
                    case 1: {
                        tokens.add(new Token(TokenType.OP, String.valueOf(c)));
                        continue block12;
                    }
                    case 2: {
                        if (exprType == Expressionator.Type.DEFAULT_VALUE && c == '=' && buf.prevPos() == 0) {
                            tokens.add(new Token(TokenType.OP, String.valueOf(c)));
                            continue block12;
                        }
                        tokens.add(new Token(TokenType.OP, ExpressionTokenizer.parseCompOp(c, buf)));
                        continue block12;
                    }
                    case 4: {
                        tokens.add(new Token(TokenType.DELIM, String.valueOf(c)));
                        continue block12;
                    }
                    case 8: {
                        ExpressionTokenizer.consumeWhitespace(buf);
                        tokens.add(new Token(TokenType.SPACE, " "));
                        continue block12;
                    }
                    case 16: {
                        switch (c) {
                            case '\"': 
                            case '\'': {
                                tokens.add(new Token(TokenType.LITERAL, null, ExpressionTokenizer.parseQuotedString(buf, c), Value.Type.STRING));
                                continue block12;
                            }
                            case '#': {
                                tokens.add(ExpressionTokenizer.parseDateLiteral(buf));
                                continue block12;
                            }
                            case '[': {
                                tokens.add(new Token(TokenType.OBJ_NAME, ExpressionTokenizer.parseObjNameString(buf)));
                                continue block12;
                            }
                            default: {
                                throw new ParseException("Invalid leading quote character " + c + " " + buf);
                            }
                        }
                    }
                    default: {
                        throw new RuntimeException("unknown char flag " + charFlag);
                    }
                }
            }
            if (ExpressionTokenizer.isDigit(c) && (numLit = ExpressionTokenizer.maybeParseNumberLiteral(c, buf)) != null) {
                tokens.add(numLit);
                continue;
            }
            String str = ExpressionTokenizer.parseBareString(c, buf, exprType);
            tokens.add(new Token(TokenType.STRING, str));
        }
        return tokens;
    }

    private static byte getCharFlag(char c) {
        return c < '\u0080' ? CHAR_FLAGS[c] : (byte)0;
    }

    private static boolean isSpecialChar(char c) {
        return ExpressionTokenizer.getCharFlag(c) != 0;
    }

    private static String parseCompOp(char firstChar, ExprBuf buf) {
        String tmpStr;
        String opStr = String.valueOf(firstChar);
        int c = buf.peekNext();
        if (c != -1 && ExpressionTokenizer.hasFlag(ExpressionTokenizer.getCharFlag((char)c), (byte)2) && TWO_CHAR_COMP_OPS.contains(tmpStr = String.valueOf(opStr) + (char)c)) {
            opStr = tmpStr;
            buf.next();
        }
        return opStr;
    }

    private static void consumeWhitespace(ExprBuf buf) {
        int c = -1;
        while ((c = buf.peekNext()) != -1 && ExpressionTokenizer.hasFlag(ExpressionTokenizer.getCharFlag((char)c), (byte)8)) {
            buf.next();
        }
    }

    private static String parseBareString(char firstChar, ExprBuf buf, Expressionator.Type exprType) {
        StringBuilder sb = buf.getScratchBuffer().append(firstChar);
        byte stopFlags = 13;
        if (exprType == Expressionator.Type.FIELD_VALIDATOR) {
            stopFlags = (byte)(stopFlags | 2);
        }
        while (buf.hasNext()) {
            char c = buf.next();
            byte charFlag = ExpressionTokenizer.getCharFlag(c);
            if (ExpressionTokenizer.hasFlag(charFlag, stopFlags)) {
                buf.popPrev();
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String parseQuotedString(ExprBuf buf, char quoteChar) {
        return ExpressionTokenizer.parseStringUntil(buf, null, quoteChar, true);
    }

    private static String parseObjNameString(ExprBuf buf) {
        return ExpressionTokenizer.parseStringUntil(buf, Character.valueOf('['), ']', false);
    }

    private static String parseDateLiteralString(ExprBuf buf) {
        return ExpressionTokenizer.parseStringUntil(buf, null, '#', false);
    }

    static String parseStringUntil(ExprBuf buf, Character startChar, char endChar, boolean allowDoubledEscape) {
        return ExpressionTokenizer.parseStringUntil(buf, startChar, endChar, allowDoubledEscape, buf.getScratchBuffer()).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    static StringBuilder parseStringUntil(ExprBuf buf, Character startChar, char endChar, boolean allowDoubledEscape, StringBuilder sb) {
        boolean complete = false;
        while (buf.hasNext()) {
            char c;
            block6: {
                c = buf.next();
                if (c == endChar) {
                    if (allowDoubledEscape && buf.peekNext() == endChar) {
                        buf.next();
                        break block6;
                    } else {
                        complete = true;
                        break;
                    }
                }
                if (startChar != null && startChar.charValue() == c) {
                    throw new ParseException("Missing closing '" + endChar + "' for quoted string " + buf);
                }
            }
            sb.append(c);
        }
        if (!complete) {
            throw new ParseException("Missing closing '" + endChar + "' for quoted string " + buf);
        }
        return sb;
    }

    private static Token parseDateLiteral(ExprBuf buf) {
        String dateStr = ExpressionTokenizer.parseDateLiteralString(buf);
        TemporalConfig.Type type = ExpressionTokenizer.determineDateType(dateStr, buf.getContext());
        if (type == null) {
            throw new ParseException("Invalid date/time literal " + dateStr + " " + buf);
        }
        DateTimeFormatter parseDf = buf.getParseDateTimeFormat(type);
        try {
            TemporalAccessor parsedInfo = parseDf.parse(dateStr);
            LocalDate ld = ColumnImpl.BASE_LD;
            if (type.includesDate()) {
                ld = LocalDate.from(parsedInfo);
            }
            LocalTime lt = ColumnImpl.BASE_LT;
            if (type.includesTime()) {
                lt = LocalTime.from(parsedInfo);
            }
            return new Token(TokenType.LITERAL, LocalDateTime.of(ld, lt), dateStr, type.getValueType());
        }
        catch (DateTimeException de) {
            throw new ParseException("Invalid date/time literal " + dateStr + " " + buf, de);
        }
    }

    static TemporalConfig.Type determineDateType(String dateStr, LocaleContext ctx) {
        TemporalConfig cfg = ctx.getTemporalConfig();
        boolean hasDate = dateStr.indexOf(cfg.getDateSeparator()) >= 0;
        boolean hasTime = dateStr.indexOf(cfg.getTimeSeparator()) >= 0;
        boolean hasAmPm = false;
        if (hasTime) {
            String[] amPmStrs = cfg.getAmPmStrings();
            String amStr = " " + amPmStrs[0];
            String pmStr = " " + amPmStrs[1];
            boolean bl = hasAmPm = ExpressionTokenizer.hasSuffix(dateStr, amStr) || ExpressionTokenizer.hasSuffix(dateStr, pmStr);
        }
        if (hasDate) {
            if (hasTime) {
                return hasAmPm ? TemporalConfig.Type.DATE_TIME_12 : TemporalConfig.Type.DATE_TIME_24;
            }
            return TemporalConfig.Type.DATE;
        }
        if (hasTime) {
            return hasAmPm ? TemporalConfig.Type.TIME_12 : TemporalConfig.Type.TIME_24;
        }
        return null;
    }

    private static boolean hasSuffix(String str, String suffStr) {
        int suffStrLen;
        int strLen = str.length();
        return strLen >= (suffStrLen = suffStr.length()) && str.regionMatches(true, strLen - suffStrLen, suffStr, 0, suffStrLen);
    }

    /*
     * Exception decompiling
     */
    private static Token maybeParseNumberLiteral(char firstChar, ExprBuf buf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean hasFlag(byte charFlag, byte flag) {
        return (charFlag & flag) != 0;
    }

    private static void setCharFlag(byte flag, char ... chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = c = cArray[n2];
            CHAR_FLAGS[c2] = (byte)(CHAR_FLAGS[c2] | flag);
            ++n2;
        }
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    static <K, V> Map.Entry<K, V> newEntry(K a, V b) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(a, b);
    }

    static final class ExprBuf {
        private final String _str;
        private final Expressionator.ParseContext _ctx;
        private int _pos;
        private final Map<TemporalConfig.Type, DateTimeFormatter> _dateTimeFmts = new EnumMap<TemporalConfig.Type, DateTimeFormatter>(TemporalConfig.Type.class);
        private final StringBuilder _scratch = new StringBuilder();

        ExprBuf(String str, Expressionator.ParseContext ctx) {
            this._str = str;
            this._ctx = ctx;
        }

        private int len() {
            return this._str.length();
        }

        public int curPos() {
            return this._pos;
        }

        public int prevPos() {
            return this._pos - 1;
        }

        public boolean hasNext() {
            return this._pos < this.len();
        }

        public char next() {
            return this._str.charAt(this._pos++);
        }

        public void popPrev() {
            --this._pos;
        }

        public int peekNext() {
            if (!this.hasNext()) {
                return -1;
            }
            return this._str.charAt(this._pos);
        }

        public void reset(int pos) {
            this._pos = pos;
        }

        public StringBuilder getScratchBuffer() {
            this._scratch.setLength(0);
            return this._scratch;
        }

        public Expressionator.ParseContext getContext() {
            return this._ctx;
        }

        public DateTimeFormatter getParseDateTimeFormat(TemporalConfig.Type type) {
            DateTimeFormatter df = this._dateTimeFmts.get((Object)type);
            if (df == null) {
                df = this._ctx.createDateFormatter(this._ctx.getTemporalConfig().getDateTimeFormat(type));
                this._dateTimeFmts.put(type, df);
            }
            return df;
        }

        public String toString() {
            return "[char " + this._pos + "] '" + this._str + "'";
        }
    }

    static final class Token {
        private final TokenType _type;
        private final Object _val;
        private final String _valStr;
        private final Value.Type _valType;

        private Token(TokenType type, String val) {
            this(type, val, val);
        }

        private Token(TokenType type, Object val, String valStr) {
            this(type, val, valStr, null);
        }

        private Token(TokenType type, Object val, String valStr, Value.Type valType) {
            this._type = type;
            this._val = val != null ? val : valStr;
            this._valStr = valStr;
            this._valType = valType;
        }

        public TokenType getType() {
            return this._type;
        }

        public Object getValue() {
            return this._val;
        }

        public String getValueStr() {
            return this._valStr;
        }

        public Value.Type getValueType() {
            return this._valType;
        }

        public String toString() {
            if (this._type == TokenType.SPACE) {
                return "' '";
            }
            String str = "[" + (Object)((Object)this._type) + "] '" + this._val + "'";
            if (this._valType != null) {
                str = String.valueOf(str) + " (" + (Object)((Object)this._valType) + ")";
            }
            return str;
        }
    }

    static enum TokenType {
        OBJ_NAME,
        LITERAL,
        OP,
        DELIM,
        STRING,
        SPACE;

    }
}

