/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.BaseValue;
import com.healthmarketscience.jackcess.impl.expr.DefaultDateFunctions;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import org.apache.commons.lang3.StringUtils;

public class StringValue
extends BaseValue {
    private static final Object NOT_A_NUMBER = new Object();
    private final String _val;
    private Object _num;

    public StringValue(String val) {
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.STRING;
    }

    @Override
    public Object get() {
        return this._val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return true;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return this._val;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this.roundToLongInt(ctx);
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this.getNumber(ctx).doubleValue();
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return this.getNumber(ctx);
    }

    @Override
    public Value getAsDateTimeValue(LocaleContext ctx) {
        Value dateValue = DefaultDateFunctions.stringToDateValue(ctx, this._val);
        if (dateValue == null) {
            try {
                dateValue = DefaultDateFunctions.numberToDateValue(this.getNumber(ctx).doubleValue());
            }
            catch (EvalException evalException) {}
            if (dateValue == null) {
                throw this.invalidConversion(Value.Type.DATE_TIME);
            }
        }
        return dateValue;
    }

    protected BigDecimal getNumber(LocaleContext ctx) {
        if (this._num instanceof BigDecimal) {
            return (BigDecimal)this._num;
        }
        if (this._num == null) {
            try {
                String tmpVal = this._val.trim();
                if (tmpVal.length() > 0) {
                    if (tmpVal.charAt(0) != '&') {
                        tmpVal = StringValue.toCanonicalNumberFormat(ctx, tmpVal);
                        this._num = ValueSupport.normalize(new BigDecimal(tmpVal));
                        return (BigDecimal)this._num;
                    }
                    if (ValueSupport.HEX_PAT.matcher(tmpVal).matches()) {
                        return this.parseIntegerString(tmpVal, 16);
                    }
                    if (ValueSupport.OCTAL_PAT.matcher(tmpVal).matches()) {
                        return this.parseIntegerString(tmpVal, 8);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this._num = NOT_A_NUMBER;
        }
        throw this.invalidConversion(Value.Type.DOUBLE);
    }

    private BigDecimal parseIntegerString(String tmpVal, int radix) {
        this._num = new BigDecimal(ValueSupport.parseIntegerString(tmpVal, radix));
        return (BigDecimal)this._num;
    }

    private static String toCanonicalNumberFormat(LocaleContext ctx, String tmpVal) {
        DecimalFormatSymbols syms = ctx.getNumericConfig().getDecimalFormatSymbols();
        char groupSepChar = syms.getGroupingSeparator();
        tmpVal = StringUtils.remove((String)tmpVal, (char)groupSepChar);
        char decSepChar = syms.getDecimalSeparator();
        if (decSepChar != '.' && tmpVal.indexOf(decSepChar) >= 0) {
            tmpVal = tmpVal.replace(decSepChar, '.');
        }
        return tmpVal;
    }
}

