/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.query;

import com.healthmarketscience.jackcess.impl.query.BaseSelectQueryImpl;
import com.healthmarketscience.jackcess.impl.query.QueryFormat;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.AppendQuery;
import com.healthmarketscience.jackcess.query.Query;
import java.util.List;

public class AppendQueryImpl
extends BaseSelectQueryImpl
implements AppendQuery {
    public AppendQueryImpl(String name, List<QueryImpl.Row> rows, int objectId, int objectFlag) {
        super(name, rows, objectId, objectFlag, Query.Type.APPEND);
    }

    @Override
    public String getTargetTable() {
        return this.getTypeRow().name1;
    }

    @Override
    public List<String> getTargetColumns() {
        return new QueryImpl.RowFormatter(this.getTargetRows()){

            @Override
            protected void format(StringBuilder builder, QueryImpl.Row row) {
                AppendQueryImpl.toOptionalQuotedExpr(builder, row.name2, true);
            }
        }.format();
    }

    @Override
    public String getRemoteDbPath() {
        return this.getTypeRow().name2;
    }

    @Override
    public String getRemoteDbType() {
        return this.getTypeRow().expression;
    }

    @Override
    public List<String> getValues() {
        return new QueryImpl.RowFormatter(this.getValueRows()){

            @Override
            protected void format(StringBuilder builder, QueryImpl.Row row) {
                builder.append(row.expression);
            }
        }.format();
    }

    protected List<QueryImpl.Row> getValueRows() {
        return AppendQueryImpl.filterRowsByFlag(super.getColumnRows(), (short)Short.MIN_VALUE);
    }

    @Override
    protected List<QueryImpl.Row> getColumnRows() {
        return AppendQueryImpl.filterRowsByNotFlag(super.getColumnRows(), (short)Short.MIN_VALUE);
    }

    protected List<QueryImpl.Row> getTargetRows() {
        return new QueryImpl.RowFilter(){

            @Override
            protected boolean keep(QueryImpl.Row row) {
                return row.name2 != null;
            }
        }.filter(super.getColumnRows());
    }

    @Override
    protected void toSQLString(StringBuilder builder) {
        builder.append("INSERT INTO ");
        AppendQueryImpl.toOptionalQuotedExpr(builder, this.getTargetTable(), true);
        List<String> columns = this.getTargetColumns();
        if (!columns.isEmpty()) {
            builder.append(" (").append(columns).append(')');
        }
        AppendQueryImpl.toRemoteDb(builder, this.getRemoteDbPath(), this.getRemoteDbType());
        builder.append(QueryFormat.NEWLINE);
        List<String> values = this.getValues();
        if (!values.isEmpty()) {
            builder.append("VALUES (").append(values).append(')');
        } else {
            this.toSQLSelectString(builder, true);
        }
    }
}

