/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.impl.ColEvalContext;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.expr.FormatUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ColumnFormatter {
    private final ColumnImpl _col;
    private final FormatEvalContext _ctx;
    private String _fmtStr;
    private FormatUtil.StandaloneFormatter _fmt;

    public ColumnFormatter(Column col) throws IOException {
        this._col = (ColumnImpl)col;
        this._ctx = new FormatEvalContext(this._col);
        this.reload();
    }

    public String getFormatString() {
        return this._fmtStr;
    }

    public void setFormatString(String fmtStr) throws IOException {
        PropertyMap props = this._col.getProperties();
        if (!StringUtils.isEmpty((CharSequence)fmtStr)) {
            props.put("Format", fmtStr);
        } else {
            props.remove("Format");
        }
        props.save();
        this.reload();
    }

    public String format(Object val) {
        return this._ctx.format(val);
    }

    public String getRowValue(Object[] rowArray) {
        return this.format(this._col.getRowValue(rowArray));
    }

    public String getRowValue(Map<String, ?> rowMap) {
        return this.format(this._col.getRowValue(rowMap));
    }

    public final void reload() throws IOException {
        this._fmt = null;
        this._fmtStr = null;
        this._fmtStr = (String)this._col.getProperties().getValue("Format");
        this._fmt = FormatUtil.createStandaloneFormatter(this._ctx, this._fmtStr, 1, 1);
    }

    private class FormatEvalContext
    extends ColEvalContext {
        private FormatEvalContext(ColumnImpl col) {
            super(col);
        }

        public String format(Object val) {
            try {
                return ColumnFormatter.this._fmt.format(this.toValue(val)).getAsString(this);
            }
            catch (EvalException evalException) {
                return val.toString();
            }
        }
    }
}

