/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.util.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.util.EntryIterableBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Joiner {
    private final Index _fromIndex;
    private final List<? extends Index.Column> _fromCols;
    private final IndexCursor _toCursor;
    private final Object[] _entryValues;

    private Joiner(Index fromIndex, IndexCursor toCursor) {
        this._fromIndex = fromIndex;
        this._fromCols = this._fromIndex.getColumns();
        this._entryValues = new Object[this._fromCols.size()];
        this._toCursor = toCursor;
    }

    public static Joiner create(Table fromTable, Table toTable) throws IOException {
        return Joiner.create(fromTable.getForeignKeyIndex(toTable));
    }

    public static Joiner create(Index fromIndex) throws IOException {
        Index toIndex = fromIndex.getReferencedIndex();
        IndexCursor toCursor = CursorBuilder.createCursor(toIndex);
        toCursor.setColumnMatcher(CaseInsensitiveColumnMatcher.INSTANCE);
        return new Joiner(fromIndex, toCursor);
    }

    public Joiner createReverse() throws IOException {
        return Joiner.create(this.getToTable(), this.getFromTable());
    }

    public Table getFromTable() {
        return this.getFromIndex().getTable();
    }

    public Index getFromIndex() {
        return this._fromIndex;
    }

    public Table getToTable() {
        return this.getToCursor().getTable();
    }

    public Index getToIndex() {
        return this.getToCursor().getIndex();
    }

    public IndexCursor getToCursor() {
        return this._toCursor;
    }

    public List<? extends Index.Column> getColumns() {
        return this._fromCols;
    }

    public boolean hasRows(Map<String, ?> fromRow) throws IOException {
        this.toEntryValues(fromRow);
        return this._toCursor.findFirstRowByEntry(this._entryValues);
    }

    public boolean hasRows(Object[] fromRow) throws IOException {
        this.toEntryValues(fromRow);
        return this._toCursor.findFirstRowByEntry(this._entryValues);
    }

    public Row findFirstRow(Map<String, ?> fromRow) throws IOException {
        return this.findFirstRow(fromRow, null);
    }

    public Row findFirstRow(Map<String, ?> fromRow, Collection<String> columnNames) throws IOException {
        return this.hasRows(fromRow) ? this._toCursor.getCurrentRow(columnNames) : null;
    }

    public EntryIterableBuilder findRows(Map<String, ?> fromRow) {
        this.toEntryValues(fromRow);
        return this._toCursor.newEntryIterable(this._entryValues);
    }

    public EntryIterableBuilder findRows(Object[] fromRow) {
        this.toEntryValues(fromRow);
        return this._toCursor.newEntryIterable(this._entryValues);
    }

    public boolean deleteRows(Map<String, ?> fromRow) throws IOException {
        return Joiner.deleteRowsImpl(this.findRows(fromRow).setColumnNames(Collections.emptySet()).iterator());
    }

    public boolean deleteRows(Object[] fromRow) throws IOException {
        return Joiner.deleteRowsImpl(this.findRows(fromRow).setColumnNames(Collections.emptySet()).iterator());
    }

    private static boolean deleteRowsImpl(Iterator<Row> iter) throws IOException {
        boolean removed = false;
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
            removed = true;
        }
        return removed;
    }

    private void toEntryValues(Map<String, ?> fromRow) {
        int i = 0;
        while (i < this._entryValues.length) {
            this._entryValues[i] = this._fromCols.get(i).getColumn().getRowValue(fromRow);
            ++i;
        }
    }

    private void toEntryValues(Object[] fromRow) {
        int i = 0;
        while (i < this._entryValues.length) {
            this._entryValues[i] = this._fromCols.get(i).getColumn().getRowValue(fromRow);
            ++i;
        }
    }

    public String toFKString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Foreign Key from ");
        String fromType = "] (primary)";
        String toType = "] (secondary)";
        if (!((IndexImpl)this._fromIndex).getReference().isPrimaryTable()) {
            fromType = "] (secondary)";
            toType = "] (primary)";
        }
        sb.append(this.getFromTable().getName()).append("[");
        sb.append(this._fromCols.get(0).getName());
        int i = 1;
        while (i < this._fromCols.size()) {
            sb.append(",").append(this._fromCols.get(i).getName());
            ++i;
        }
        sb.append(fromType);
        sb.append(" to ").append(this.getToTable().getName()).append("[");
        List<? extends Index.Column> toCols = this._toCursor.getIndex().getColumns();
        sb.append(toCols.get(0).getName());
        int i2 = 1;
        while (i2 < toCols.size()) {
            sb.append(",").append(toCols.get(i2).getName());
            ++i2;
        }
        sb.append(toType).append(" (Db=").append(((DatabaseImpl)this.getFromTable().getDatabase()).getName()).append(")");
        return sb.toString();
    }
}

