/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.analisys.gui.parts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.PlotType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.ChartValuesTable;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.gui.di.PersistedIdObject;
import de.elpro.resources.Resources;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.model.IdObject;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.beans.property.Property;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class DynamicPieChartPart {
    public static final String ID = "de.elpro.ewms.analisys.gui.partdescriptor.charts.dynamicpiechart";
    public static final URL VALUES_ICON_URL = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/arraypartition_obj.gif");
    @Inject
    @PersistedIdObject
    private StructureObject structureObject;
    @Inject
    @PersistedIdObject
    private VariableInstance[] variableInstances;
    private ITimeRangeFilter timeRangeFilter;
    @Inject
    @Log
    private Logger logger;
    private Set<VariableInstance> allInstances = new HashSet<VariableInstance>();
    private Chart2DView jfcv;
    private ChartValuesTable valuesTable;
    private ProgressIndicatorPane valuesTablePane;
    private CheckMenuItem showTableValuesItem;
    private final Chart2D chart = new Chart2D();
    @Inject
    @ContextValue(value="exportable-items")
    private Property<List<IExportable>> exportItemsProperty;
    private ArrayList<IExportable> exportItems;
    @Inject
    private MPart part;

    @PostConstruct
    public void postConstruct(BorderPane parent, Scene scene, IEclipseContext context) throws IllegalConfigException {
        this.addVariableInstances(this.variableInstances);
        this.chart.setPlotType(PlotType.RingPlot);
        this.jfcv = Chart2DView.create((Chart2D)this.chart, (IEclipseContext)context.createChild());
        this.jfcv.setUseStructureObjectColorsForObject(false);
        this.jfcv.setShowFullSeriesNames(true);
        this.exportItems = new ArrayList();
        this.exportItems.add((IExportable)this.jfcv);
        this.exportItemsProperty.setValue(this.exportItems);
        SplitPane spliter = new SplitPane(new Node[]{this.jfcv});
        spliter.setOrientation(Orientation.VERTICAL);
        this.showTableValuesItem = new CheckMenuItem("Values", (Node)new ImageView(VALUES_ICON_URL.toString()));
        this.showTableValuesItem.setOnAction(e -> {
            if (this.showTableValuesItem.isSelected()) {
                if (this.valuesTable == null) {
                    this.valuesTable = new ChartValuesTable(this.jfcv.toString());
                    this.valuesTable.getColumns().addAll(this.jfcv.getVarValuesColumns());
                    this.valuesTable.hasChangesProperty().addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
                    ProgressIndicatorPane pip = this.valuesTablePane = new ProgressIndicatorPane((Node)this.valuesTable);
                    ChartValuesTable fvvt = this.valuesTable;
                    this.jfcv.stateProperty().addListener((o, ov, nv) -> {
                        pip.showIndicator(nv == UIObjectState.Loading);
                        if (nv == UIObjectState.Ready) {
                            fvvt.getColumns().setAll(this.jfcv.getVarValuesColumns());
                        }
                    });
                    this.jfcv.dataSelectionProperty().addListener((o, ov, nv) -> fvvt.selectData(nv.getEndTimestamp(), nv.getObject()));
                    fvvt.dataSelectionProperty().addListener((o, ov, nv) -> this.jfcv.selectData(nv.getEndTimestamp(), nv.getObject()));
                }
                this.exportItems = new ArrayList<IExportable>(this.exportItems);
                this.exportItems.add((IExportable)this.valuesTable);
                this.exportItemsProperty.setValue(this.exportItems);
                spliter.getItems().add((Object)this.valuesTablePane);
            } else {
                Node varTable = null;
                for (Node tableCandidate : spliter.getItems()) {
                    if (!(tableCandidate instanceof ProgressIndicatorPane) || !(((ProgressIndicatorPane)tableCandidate).getContent() instanceof ChartValuesTable)) continue;
                    ChartValuesTable cfr_ignored_0 = (ChartValuesTable)((ProgressIndicatorPane)tableCandidate).getContent();
                    varTable = tableCandidate;
                }
                if (varTable != null) {
                    spliter.getItems().remove(varTable);
                    this.exportItems = new ArrayList<IExportable>(this.exportItems);
                    this.exportItems.remove(this.valuesTable);
                    this.exportItemsProperty.setValue(this.exportItems);
                }
            }
        });
        this.jfcv.setContextMenu(new ContextMenu(new MenuItem[]{this.showTableValuesItem}));
        parent.setCenter((Node)spliter);
        this.jfcv.setOnDragOver(event -> {
            String[] stringArray;
            String clipboardContent;
            if (event.getGestureSource() != this.jfcv && (clipboardContent = event.getDragboard().getString()) != null && (stringArray = clipboardContent.split(";")).length != 0) {
                String part = stringArray[0];
                IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                if (o instanceof VariableInstance) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
            }
            event.consume();
        });
        this.jfcv.setOnDragDropped(event -> {
            String clipboardContent = event.getDragboard().getString();
            if (clipboardContent != null) {
                AbstractCollection instancesToAdd = new HashSet();
                String[] stringArray = clipboardContent.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                    if (o instanceof VariableInstance) {
                        VariableInstance instance = (VariableInstance)o;
                        instancesToAdd.add(instance);
                    }
                    ++n2;
                }
                instancesToAdd = new LinkedList(instancesToAdd);
                Collections.sort((List)((Object)instancesToAdd));
                try {
                    if (!instancesToAdd.isEmpty()) {
                        this.addVariableInstances(instancesToAdd.toArray(new VariableInstance[0]));
                    }
                }
                catch (IllegalConfigException e) {
                    this.logger.error("Error adding instances", (Throwable)e);
                }
            }
            event.consume();
        });
    }

    public void addVariableInstances(VariableInstance[] instances) throws IllegalConfigException {
        Transaction trx = Transactions.begin();
        try {
            VariableInstance[] variableInstanceArray = instances;
            int n = instances.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstance instance = variableInstanceArray[n2];
                if (!this.allInstances.contains(instance)) {
                    SeriesGroup group;
                    YAxis yAxis;
                    VariableInstance inst = VariableInstanceDAO.get((Transaction)trx, (int)instance.getId());
                    inst.setVariable(VariableDAO.get((Transaction)trx, (int)inst.getVariable().getId()));
                    Optional<YAxis> yAxisOp = this.chart.getYAxes().stream().filter(a -> a.getPhysicalUnit() == inst.getVariable().getPhysicalUnit()).findAny();
                    if (yAxisOp.isPresent()) {
                        yAxis = yAxisOp.get();
                        group = (SeriesGroup)yAxis.getSeriesGroups().get(0);
                    } else {
                        yAxis = new YAxis();
                        yAxis.setPhysicalUnit(inst.getVariable().getPhysicalUnit());
                        yAxis.setDefaultMeasuringUnit(inst.getVariable().getMeasuringUnit());
                        this.chart.getYAxes().add(yAxis);
                        group = new SeriesGroup();
                        group.setType(yAxis.getDefaultRendererType());
                        group.setYAxis(yAxis);
                        yAxis.getSeriesGroups().add(group);
                        String muName = inst.getVariable().getPhysicalUnit().getName();
                        if (muName != null && !muName.isEmpty()) {
                            yAxis.setTitle(muName);
                        }
                    }
                    VarSeries2D series = new VarSeries2D();
                    series.setVariable(inst.getVariable());
                    series.setVariableInstance(inst);
                    series.setYAxis(yAxis);
                    series.setSeriesGroup(group);
                    group.getSeries().add(series);
                    this.allInstances.add(instance);
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        if (this.jfcv != null) {
            this.jfcv.applyConfig(this.chart);
            this.exportItems = new ArrayList();
            this.exportItems.add((IExportable)this.jfcv);
            if (this.valuesTable != null && this.showTableValuesItem.isSelected()) {
                this.exportItems.add((IExportable)this.valuesTable);
            }
            this.exportItemsProperty.setValue(this.exportItems);
            this.refresh();
        }
    }

    @Refresh
    public void refresh() {
        this.jfcv.reloadData();
    }

    @Inject
    private void reloadData(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (this.jfcv != null) {
            this.jfcv.loadData(timeRangeFilter);
        }
    }

    @PersistState
    public void persistUIState(Memento state) {
        state.put(StructureObject.class.getName(), (Object)this.structureObject, "fx.idobject_serializer");
        state.put(VariableInstance[].class.getName(), (Object)this.allInstances.toArray(new VariableInstance[0]), "fx.idobject_serializer");
    }

    @PreDestroy
    public void preDestroy() {
        this.jfcv.dispose();
        this.jfcv = null;
        List exportables = (List)this.exportItemsProperty.getValue();
        if (exportables != null) {
            exportables.removeAll(this.exportItems);
            this.exportItemsProperty.setValue(new ArrayList(exportables));
        }
        this.exportItems = null;
    }
}

