/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.analisys.gui.parts;

import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.charts.SankeyNodeType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.charts.SankeyChartView;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.gui.di.PersistedIdObject;
import de.elpro.resources.Resources;
import de.elpro.ui.di.Refresh;
import java.net.URL;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class DynamicSankeyChartPart {
    public static final String ID = "de.elpro.ewms.analisys.gui.partdescriptor.charts.dynamicsankeychart";
    public static final URL VALUES_ICON_URL = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/arraypartition_obj.gif");
    @Inject
    @PersistedIdObject
    private StructureObject structureObject;
    @Inject
    @PersistedIdObject
    private Variable variable;
    private ITimeRangeFilter timeRangeFilter;
    @Inject
    @Log
    private Logger logger;
    private SankeyChartView sankeyChartView;

    @PostConstruct
    public void postConstruct(BorderPane parent, Scene scene) throws IllegalConfigException {
        new Thread(() -> Platform.runLater(() -> {
            Transaction trx = Transactions.begin();
            try {
                this.structureObject = StructureObjectDAO.get((Transaction)trx, (int)this.structureObject.getId());
                this.variable = VariableDAO.get((Transaction)trx, (int)this.variable.getId());
                SankeyChart chart = new SankeyChart();
                chart.setPhysicalUnit(this.variable.getPhysicalUnit());
                SankeyNode node = new SankeyNode();
                node.setStructureClass(this.variable.getStructureClass());
                node.setVariable(this.variable);
                node.setType(SankeyNodeType.Recursive);
                chart.getRootNodes().add(node);
                this.sankeyChartView = new SankeyChartView(chart, this.structureObject, this.timeRangeFilter);
                parent.setCenter((Node)this.sankeyChartView);
                this.refresh();
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        })).start();
    }

    @Refresh
    public void refresh() {
        this.sankeyChartView.reloadData();
    }

    @Inject
    private void reloadData(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (this.sankeyChartView != null) {
            this.sankeyChartView.loadData(timeRangeFilter);
        }
    }

    @PersistState
    public void persistUIState(Memento state) {
        state.put(StructureObject.class.getName(), (Object)this.structureObject, "fx.idobject_serializer");
        state.put(Variable.class.getName(), (Object)this.variable, "fx.idobject_serializer");
    }

    @PreDestroy
    public void preDestroy() {
    }
}

