/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.analisys.gui.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.fx.core.di.ContextValue;

public class ObjectSeriesPart {
    public static final String ID = "de.elpro.ewms.analisys.gui.part.objectseries";
    public static final String MENU_ID = "de.elpro.ewms.analisys.gui.popupmenu.objectseries";
    private final ObservableList<VariableInstance> instances = FXCollections.observableArrayList();
    private final ListView<VariableInstance> listView = new ListView(this.instances);
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane(this.listView);
    @Inject
    @ContextValue(value="instances-selection")
    private Property<VariableInstance[]> instancesSelection;
    @Inject
    @ContextValue(value="variable-selection")
    private Property<Variable> variableSelection;
    @Inject
    private EMenuService menuService;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.listView.setCellFactory(cf -> new UIModelListCell());
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.menuService.registerContextMenu(this.listView, MENU_ID);
        this.listView.setOnMousePressed(me -> {
            if (me.getClickCount() == 1) {
                PickResult pr = me.getPickResult();
                if (pr.getIntersectedNode().getStyleClass().contains((Object)"arrow") || pr.getIntersectedNode().getStyleClass().contains((Object)"tree-disclosure-node")) {
                    return;
                }
                Cell cell = (Cell)FXUtils.findParent((Node)pr.getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                VariableInstance lastSelectedInstance = (VariableInstance)this.listView.getSelectionModel().getSelectedItem();
                if (this.listView.getSelectionModel().getSelectedItems().size() <= 1 && lastSelectedInstance != null && lastSelectedInstance != cell.getItem()) {
                    return;
                }
                this.instancesSelection.setValue((Object)((VariableInstance[])this.listView.getSelectionModel().getSelectedItems().toArray((Object[])new VariableInstance[0])));
                VariableInstance selectedInstance = (VariableInstance)this.listView.getSelectionModel().getSelectedItem();
                if (selectedInstance != null) {
                    this.variableSelection.setValue((Object)selectedInstance.getVariable());
                }
            }
        });
        this.listView.setOnDragDetected(event -> {
            if (this.listView.getSelectionModel().getSelectedItems().isEmpty()) {
                return;
            }
            Dragboard db = this.listView.startDragAndDrop(TransferMode.ANY);
            String clipboardContent = null;
            for (VariableInstance instance : this.listView.getSelectionModel().getSelectedItems()) {
                clipboardContent = clipboardContent == null ? "" : String.valueOf(clipboardContent) + ";";
                clipboardContent = String.valueOf(clipboardContent) + instance.getFullId();
            }
            ClipboardContent content = new ClipboardContent();
            content.putString(clipboardContent);
            db.setContent((Map)content);
            event.consume();
        });
        parent.setCenter((Node)this.progressIndicator);
    }

    @Inject
    private void objectSelected(final @Named(value="object-selection") @Named(value="object-selection") StructureObject object) {
        this.listView.getSelectionModel().clearSelection();
        this.instances.clear();
        if (object == null) {
            return;
        }
        CallableTask<List<VariableInstance>> loadTask = new CallableTask<List<VariableInstance>>(){

            public List<VariableInstance> call() throws Exception {
                LinkedList<VariableInstance> loadedInstances = new LinkedList<VariableInstance>();
                Transaction trx = Transactions.begin();
                try {
                    VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (StructureObject)object);
                    int n = variableInstanceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstance instance = variableInstanceArray[n2];
                        instance.setVariable(VariableDAO.get((Transaction)trx, (int)instance.getVariable().getId()));
                        instance.setStructureObject(object);
                        instance.setBuildTextLabelCallback(i -> {
                            String description = instance.getResultDescription();
                            String varName = instance.getVariable().toString();
                            if (description == null || description.isEmpty()) {
                                return varName;
                            }
                            return String.format("%s - %s", varName, description);
                        });
                        loadedInstances.add(instance);
                        ++n2;
                    }
                    Collections.sort(loadedInstances);
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                return loadedInstances;
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)loadTask).consumeResult((state, result) -> {
            if (state == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    boolean bl = this.instances.setAll((Collection)result);
                });
            }
        });
    }
}

