/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.analisys.gui.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.di.ContextValue;

public class ObjectTreePart {
    private final TreeItem<StructureObject> rootItem = new TreeItem();
    private final TreeView<StructureObject> treeView = new TreeView(this.rootItem);
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane(this.treeView);
    @Inject
    @ContextValue(value="object-selection")
    private Property<StructureObject> objectSelection;
    @Inject
    private EPartService partService;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.treeView.setShowRoot(false);
        this.treeView.setCellFactory(cf -> new UIModelTreeCell());
        this.treeView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.objectSelection.setValue((Object)((StructureObject)nv.getValue()));
                this.partService.showPart("de.elpro.ewms.analisys.gui.part.objectseries", EPartService.PartState.VISIBLE);
            }
        });
        parent.setCenter((Node)this.progressIndicator);
        CallableTask<List<TreeItem<StructureObject>>> loadTreeTask = new CallableTask<List<TreeItem<StructureObject>>>(){

            public List<TreeItem<StructureObject>> call() throws Exception {
                return ObjectTreePart.this.getChildren();
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)loadTreeTask).consumeResult((state, result) -> {
            if (state == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    boolean bl = this.rootItem.getChildren().setAll((Collection)result);
                });
            }
        });
    }

    public List<TreeItem<StructureObject>> getChildren() {
        LinkedList<TreeItem<StructureObject>> rootObjects = new LinkedList<TreeItem<StructureObject>>();
        Transaction trx = Transactions.begin();
        try {
            StructureObject[] structureObjectArray = StructureObjectDAO.getRoots((Transaction)trx);
            int n = structureObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject rootObject = structureObjectArray[n2];
                TreeItem item = new TreeItem((Object)rootObject);
                rootObjects.add((TreeItem<StructureObject>)item);
                this.addRecursive(trx, (TreeItem<StructureObject>)item);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return rootObjects;
    }

    private void addRecursive(Transaction trx, TreeItem<StructureObject> item) {
        if (item.getValue() instanceof StructureObject) {
            StructureObject object = (StructureObject)item.getValue();
            StructureObject[] structureObjectArray = StructureObjectDAO.getChildren((Transaction)trx, (StructureObject)object);
            int n = structureObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject child = structureObjectArray[n2];
                TreeItem childItem = new TreeItem((Object)child);
                item.getChildren().add((Object)childItem);
                this.addRecursive(trx, (TreeItem<StructureObject>)childItem);
                ++n2;
            }
            FXUtils.sortTreeItems((List)item.getChildren());
        }
    }
}

