/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.analisys.gui.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.fx.core.di.ContextValue;

public class VariableSeries {
    public static final String MENU_ID = "de.elpro.ewms.analisys.gui.popupmenu.variableseries";
    private final TreeItem<UIModelElement> rootItem = new TreeItem();
    private final TreeView<UIModelElement> treeView = new TreeView(this.rootItem);
    private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane(this.treeView);
    @Inject
    @ContextValue(value="instances-selection")
    private Property<VariableInstance[]> instancesSelection;
    @Inject
    private EMenuService menuService;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.treeView.setShowRoot(false);
        this.treeView.setCellFactory(cf -> new UIModelTreeCell());
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.menuService.registerContextMenu(this.treeView, MENU_ID);
        parent.setCenter((Node)this.progressIndicator);
        this.treeView.setOnMousePressed(me -> {
            if (me.getClickCount() == 1) {
                PickResult pr = me.getPickResult();
                if (pr.getIntersectedNode().getStyleClass().contains((Object)"arrow") || pr.getIntersectedNode().getStyleClass().contains((Object)"tree-disclosure-node")) {
                    return;
                }
                Cell cell = (Cell)FXUtils.findParent((Node)pr.getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                TreeItem lastSelectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                ArrayList<Object> instances = new ArrayList<Object>();
                if (this.treeView.getSelectionModel().getSelectedItems().size() <= 1) {
                    if (lastSelectedItem != null && lastSelectedItem.getValue() != cell.getItem()) {
                        return;
                    }
                    if (lastSelectedItem.getValue() instanceof Variable) {
                        instances.addAll(((Variable)lastSelectedItem.getValue()).getInstances());
                    } else if (lastSelectedItem.getValue() instanceof VariableInstance) {
                        instances.add((VariableInstance)lastSelectedItem.getValue());
                    }
                } else {
                    HashSet<VariableInstance> selectedInstances = new HashSet<VariableInstance>();
                    for (TreeItem item : this.treeView.getSelectionModel().getSelectedItems()) {
                        if (item.getValue() instanceof Variable) {
                            selectedInstances.addAll(((Variable)item.getValue()).getInstances());
                            break;
                        }
                        if (!(item.getValue() instanceof VariableInstance)) continue;
                        selectedInstances.add((VariableInstance)item.getValue());
                    }
                    instances.addAll(selectedInstances);
                }
                Collections.sort(instances, (i1, i2) -> i1.getStructureObject().compareTo((Object)i2.getStructureObject()));
                this.instancesSelection.setValue((Object)instances.toArray(new VariableInstance[0]));
            }
        });
        this.treeView.setOnDragDetected(event -> {
            if (this.instancesSelection.getValue() == null || ((VariableInstance[])this.instancesSelection.getValue()).length == 0) {
                return;
            }
            Dragboard db = this.treeView.startDragAndDrop(TransferMode.ANY);
            String clipboardContent = null;
            VariableInstance[] variableInstanceArray = (VariableInstance[])this.instancesSelection.getValue();
            int n = variableInstanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableInstance instance = variableInstanceArray[n2];
                clipboardContent = clipboardContent == null ? "" : String.valueOf(clipboardContent) + ";";
                clipboardContent = String.valueOf(clipboardContent) + instance.getFullId();
                ++n2;
            }
            ClipboardContent content = new ClipboardContent();
            content.putString(clipboardContent);
            db.setContent((Map)content);
            event.consume();
        });
    }

    @Inject
    private void variableSelected(final @Named(value="variable-selection") @Named(value="variable-selection") Variable variable) {
        this.treeView.getSelectionModel().clearSelection();
        if (variable == null) {
            this.rootItem.getChildren().clear();
            return;
        }
        CallableTask<TreeItem<UIModelElement>> loadInstances = new CallableTask<TreeItem<UIModelElement>>(){

            public TreeItem<UIModelElement> call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    VariableInstance[] instances;
                    Variable var = VariableDAO.get((Transaction)trx, (int)variable.getId());
                    var.getInstances().clear();
                    TreeItem varItem = new TreeItem((Object)var);
                    VariableInstance[] variableInstanceArray = instances = VariableInstanceDAO.getAll((Transaction)trx, (Variable)variable);
                    int n = instances.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VariableInstance instance = variableInstanceArray[n2];
                        instance.setVariable(variable);
                        instance.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId()));
                        var.getInstances().add(instance);
                        varItem.getChildren().add((Object)new TreeItem((Object)instance));
                        ++n2;
                    }
                    FXUtils.sortTreeItems((List)varItem.getChildren());
                    varItem.setExpanded(true);
                    TreeItem treeItem = varItem;
                    return treeItem;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)loadInstances).consumeResult((state, result) -> {
            if (state == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    this.rootItem.getChildren().setAll(Collections.singletonList(result));
                    if (this.instancesSelection.getValue() != null && ((VariableInstance[])this.instancesSelection.getValue()).length == 1) {
                        for (TreeItem iItem : result.getChildren()) {
                            if (!((VariableInstance[])this.instancesSelection.getValue())[0].equals(iItem.getValue())) continue;
                            this.treeView.getSelectionModel().select((Object)iItem);
                        }
                    }
                });
            }
        });
    }
}

