/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.elpro.ewms.core.client.UntrustedCertException;
import de.elpro.ewms.core.client.bundle.Activator;
import de.elpro.ewms.core.client.preferences.Preferences;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.resources.ResourcesDAO;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.json.JsonParser;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathChecker;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.fx.core.log.Logger;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.internal.MultiPartReaderClientSide;
import org.glassfish.jersey.media.multipart.internal.MultiPartWriter;

public class Client {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Client.class.getName());
    private static javax.ws.rs.client.Client client;
    private static WebTarget target;
    private static ServerInfo serverInfo;

    public static void connect(String targetUrl, KeyStore myCertKeyStore, KeyStore trustedKeyStore) throws Exception {
        Client.disconnect();
        System.setProperty("https.protocols", "TLSv1.2");
        SslConfigurator sslConfig = SslConfigurator.newInstance((boolean)true).keyStore(myCertKeyStore).trustStore(trustedKeyStore);
        SSLContext sslContext = sslConfig.createSSLContext();
        sslContext.init(null, new TrustManager[]{new EOSClientTrustManager(trustedKeyStore)}, null);
        ClientConfig config = new ClientConfig(new Class[]{JsonParser.class, MultiPartReaderClientSide.class, MultiPartWriter.class});
        ClientBuilder builder = ClientBuilder.newBuilder().sslContext(sslContext).withConfig((Configuration)config);
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(Client.class.getName());
        new LoggingFeature(logger, Level.INFO, null, null);
        client = builder.build();
        target = client.target(targetUrl);
        try {
            Client.getWebTarget().path("/").request().get();
        }
        catch (ProcessingException exc) {
            sslContext.getClientSessionContext();
            Throwable cause = exc.getCause();
            if (cause instanceof SSLHandshakeException && (cause = cause.getCause()) instanceof UntrustedCertException) {
                Client.disconnect();
                throw (UntrustedCertException)cause;
            }
            throw exc;
        }
        try {
            serverInfo = ServerDAO.getInfo();
        }
        catch (Exception exc) {
            Client.logger.error("Error reading server info. Old server?", (Throwable)exc);
        }
    }

    public static void initClient() {
        VirtualZone.INSTANCE.setZoneOffsets(Preferences.getVirtualZone().getZoneOffsets());
        ResourceLoader.init((ResourceLoader.ResourceLoaderCallback)new ResourceLoader.ResourceLoaderCallback(){

            public InputStream getIconInputStream(String iconKey) {
                return ResourcesDAO.getIcon(iconKey);
            }
        });
    }

    public static ServerInfo getServerInfo() {
        return serverInfo;
    }

    public static void saveAuthentication(String targetUrl, String userPrincipal, String sessionKey) {
        String iso8859_1_userPrincipal = StringEscapeUtils.escapeJava((String)userPrincipal);
        HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)iso8859_1_userPrincipal, (String)sessionKey);
        client.register((Object)feature);
        target = client.target(targetUrl);
    }

    public static void disconnect() {
        if (client != null) {
            client.close();
        }
        serverInfo = null;
    }

    public static WebTarget getWebTarget() {
        return target;
    }

    private static class EOSClientTrustManager
    implements X509TrustManager {
        private final KeyStore trustedKeyStore;

        public EOSClientTrustManager(KeyStore trustedKeyStore) {
            this.trustedKeyStore = trustedKeyStore;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            HashSet x509Certificates = new HashSet();
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Arrays.asList(trustManagerFactory.getTrustManagers()).stream().forEach(t -> x509Certificates.addAll(Arrays.asList(((X509TrustManager)t).getAcceptedIssuers())));
            }
            catch (Exception exc) {
                logger.debug("Failed to load default root CA's", (Throwable)exc);
            }
            return x509Certificates.toArray(new X509Certificate[0]);
        }

        private Set<X509Certificate> getTrustedCerts() {
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            try {
                Enumeration<String> aliases = this.trustedKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    certs.add((X509Certificate)this.trustedKeyStore.getCertificate(alias));
                }
            }
            catch (KeyStoreException exc) {
                logger.error("Cannot read trusted key store", (Throwable)exc);
            }
            return certs;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            EOSClientTrustManager.verifyTrustChain(Arrays.asList(chain), this.getTrustedCerts(), new HashSet<X509Certificate>(Arrays.asList(this.getAcceptedIssuers())), new HashSet<X509CRL>());
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public static void verifyTrustChain(List<X509Certificate> certificateChain, Set<X509Certificate> trustedCertificates, Set<X509Certificate> issuerCertificates, Set<X509CRL> issuerCrls) throws UntrustedCertException {
            Preconditions.checkArgument((!certificateChain.isEmpty() ? 1 : 0) != 0, (Object)"certificateChain must not be empty");
            X509Certificate certificate = certificateChain.get(0);
            boolean certificateTrusted = trustedCertificates.stream().anyMatch(c -> Arrays.equals(certificate.getSignature(), c.getSignature()));
            if (certificateTrusted) {
                return;
            }
            try {
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                issuerCertificates.forEach(ca -> {
                    boolean bl = trustAnchors.add(new TrustAnchor((X509Certificate)ca, null));
                });
                X509CertSelector selector = new X509CertSelector();
                selector.setCertificate(certificate);
                PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
                if (certificateChain.size() > 0 || issuerCrls.size() > 0) {
                    ArrayList collection = Lists.newArrayList();
                    collection.addAll(certificateChain);
                    collection.addAll(issuerCrls);
                    CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(collection));
                    params.addCertStore(certStore);
                }
                params.setRevocationEnabled(!issuerCrls.isEmpty());
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                CertPathChecker revocationChecker = builder.getRevocationChecker();
                if (revocationChecker instanceof PKIXRevocationChecker) {
                    ((PKIXRevocationChecker)revocationChecker).setOptions(Sets.newHashSet((Object[])new PKIXRevocationChecker.Option[]{PKIXRevocationChecker.Option.NO_FALLBACK, PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.SOFT_FAIL}));
                }
                builder.build(params);
            }
            catch (Throwable throwable) {
                throw new UntrustedCertException(certificateChain.toArray(new X509Certificate[0]));
            }
        }
    }
}

