/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client;

import de.elpro.ewms.core.auth.StrongPasswordEncryptor;
import de.elpro.ewms.core.client.bundle.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.core.log.Logger;

public class KeyStoreManager {
    public static final StrongPasswordEncryptor PASSWORD_ENCRYPTOR;
    private static final Logger logger;
    private final File trustedStoreFile;
    private final KeyStore ownCertKS;
    private final KeyStore trustedKS;
    private final char[] password;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PASSWORD_ENCRYPTOR = new StrongPasswordEncryptor();
        logger = Activator.getLoggerFactory().createLogger(KeyStoreManager.class.getName());
    }

    public KeyStoreManager(File jksFile, File jtsFile, char[] password) throws Exception {
        block21: {
            FileInputStream is;
            this.trustedStoreFile = jtsFile;
            this.password = password;
            if (!jksFile.exists()) {
                KeyStoreManager.createOwnCertKeyStore(jksFile, password);
            }
            this.ownCertKS = KeyStore.getInstance("JKS");
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                is = new FileInputStream(jksFile);
                try {
                    this.ownCertKS.load(is, password);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (jtsFile.exists()) {
                this.trustedKS = KeyStore.getInstance("JKS");
                throwable = null;
                var5_7 = null;
                try {
                    is = new FileInputStream(jtsFile);
                    try {
                        this.trustedKS.load(is, password);
                        break block21;
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            this.trustedKS = KeyStore.getInstance("JKS");
            this.trustedKS.load(null, null);
        }
    }

    public KeyStore getOwnCertKeyStore() {
        return this.ownCertKS;
    }

    public KeyStore getTrustedKeyStore() {
        return this.trustedKS;
    }

    public void addToTrustedKeyStore(X509Certificate cert, boolean persist) throws FileNotFoundException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.trustedKS.setCertificateEntry(String.valueOf(cert.getSubjectDN().toString()) + "." + Instant.now().toEpochMilli(), cert);
        if (persist) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream os = new FileOutputStream(this.trustedStoreFile);){
                this.getTrustedKeyStore().store(os, this.password);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var4_6 = null;
            try (FileInputStream is = new FileInputStream(this.trustedStoreFile);){
                this.getTrustedKeyStore().load(is, this.password);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    public static File getDefaultJKSLocation() {
        IPath ownCertKSPath = Activator.getWorkspaceLocation().append("keystore").append("http-client.jks").makeAbsolute();
        return ownCertKSPath.toFile();
    }

    public static File getDefaultJTSLocation() {
        IPath trustedKSPath = Activator.getWorkspaceLocation().append("keystore").append("http-client.jts").makeAbsolute();
        return trustedKSPath.toFile();
    }

    private static void createOwnCertKeyStore(File keyStoreFile, char[] keyStorePassword) throws Exception {
        keyStoreFile.getParentFile().mkdirs();
        logger.info("Client KeyStore was not found and will be created.");
        String hostName = InetAddress.getLocalHost().getCanonicalHostName();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate selfSignedCertificate = KeyStoreManager.generateSelfSignedCertificate(keyPair, hostName);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("eos.client", keyPair.getPrivate(), keyStorePassword, new X509Certificate[]{selfSignedCertificate});
        ks.setCertificateEntry(hostName, selfSignedCertificate);
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileOutputStream os = new FileOutputStream(keyStoreFile);){
            ks.store(os, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        logger.info("KeyStore with default self signed certificate stored at: " + keyStoreFile.getAbsolutePath());
    }

    private static X509Certificate generateSelfSignedCertificate(KeyPair keyPair, String hostName) throws Exception {
        X500Name dnName = new X500Name(String.format("CN=%s", hostName));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dnName, BigInteger.valueOf(System.currentTimeMillis()), new Date(), Date.from(Instant.now().plusSeconds(94608000L)), dnName, keyPair.getPublic());
        DERSequence subjectAlternativeNames = new DERSequence(new ASN1Encodable[]{new GeneralName(2, "localhost"), new GeneralName(2, "127.0.0.1")});
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").setProvider("BC").build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(builder.build(signer));
    }
}

