/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.bundle.Activator;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import org.eclipse.fx.core.log.Logger;

public class Transactions {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Transactions.class.getName());

    public static Transaction begin() {
        TransactionIdHolder idHolder = (TransactionIdHolder)Client.getWebTarget().path(String.format("%s/begin", "transaction")).request().get(TransactionIdHolder.class);
        Runnable closeTrxCallback = () -> {
            Object object = Client.getWebTarget().path(String.format("%s/close/trx=%s", "transaction", transactionIdHolder.id)).request().get(OperationResult.class);
        };
        return new Transaction(idHolder.id, closeTrxCallback);
    }

    public static void commitSync(Transaction trx) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/commit_sync/trx=%s", "transaction", trx)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void commitAsync(Transaction trx) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/commit_async/trx=%s", "transaction", trx)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static OperationResult rollback(Transaction trx) {
        return (OperationResult)Client.getWebTarget().path(String.format("%s/rollback/trx=%s", "transaction", trx)).request().get(OperationResult.class);
    }

    public static OperationResult close(Transaction trx) {
        return (OperationResult)Client.getWebTarget().path(String.format("%s/close/trx=%s", "transaction", trx)).request().get(OperationResult.class);
    }

    private final class TransactionIdHolder {
        private int id;

        private TransactionIdHolder() {
        }
    }
}

