/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.charts.Characteristic2DSeries;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.charts.Characteristic2DSeriesDAO;
import de.elpro.ewms.core.client.charts.SeriesGroupDAO;
import de.elpro.ewms.core.client.charts.VarSeriesDAO;
import de.elpro.ewms.core.client.charts.YAxisDAO;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ChartDAO {
    private static final String PREFIX = "charts/chart2d";

    public static Chart2D get(Transaction trx, int id) {
        return (Chart2D)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Chart2D.class);
    }

    public static Chart2D loadNormalized(Transaction trx, int id) {
        Chart2D chart = ChartDAO.get(trx, id);
        if (chart.getXAxisVariable() != null) {
            chart.setXAxisVariable(VariableDAO.get(trx, chart.getXAxisVariable().getId()));
        }
        if (chart.getCharacteristic2DSeries() != null) {
            Characteristic2DSeries c2ds = Characteristic2DSeriesDAO.getByChart(trx, chart);
            chart.setCharacteristic2DSeries(c2ds);
            Characteristic2D c2d = Characteristic2DDAO.get(trx, c2ds.getCharacteristic().getId());
            c2ds.setCharacteristic(c2d);
            if (c2d.getInputValuesBounds() != null) {
                c2d.setInputValuesBounds(ValuesBoundsDAO.get(trx, c2d.getInputValuesBounds().getId()));
            }
            if (c2d.getOutputValuesBounds() != null) {
                c2d.setOutputValuesBounds(ValuesBoundsDAO.get(trx, c2d.getOutputValuesBounds().getId()));
            }
        }
        YAxis[] yAxesDefinition = YAxisDAO.getByChart(trx, chart);
        chart.getYAxes().clear();
        YAxis[] yAxisArray = yAxesDefinition;
        int n = yAxesDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis yAxisDef = yAxisArray[n2];
            chart.getYAxes().add(yAxisDef);
            SeriesGroup[] seriesGroups = SeriesGroupDAO.getByYAxis(trx, yAxisDef);
            yAxisDef.getSeriesGroups().clear();
            SeriesGroup[] seriesGroupArray = seriesGroups;
            int n3 = seriesGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                SeriesGroup seriesGroup = seriesGroupArray[n4];
                yAxisDef.getSeriesGroups().add(seriesGroup);
                VarSeries2D[] varSeriesArr = VarSeriesDAO.getBySeriesGroup(trx, seriesGroup);
                seriesGroup.getSeries().clear();
                VarSeries2D[] varSeries2DArray = varSeriesArr;
                int n5 = varSeriesArr.length;
                int n6 = 0;
                while (n6 < n5) {
                    VarSeries2D varSeries = varSeries2DArray[n6];
                    seriesGroup.getSeries().add(varSeries);
                    if (varSeries.getVariable() != null) {
                        varSeries.setVariable(VariableDAO.get(trx, varSeries.getVariable().getId()));
                    }
                    ++n6;
                }
                ++n4;
            }
            VarSeries2D[] ungroupedVarSeries = VarSeriesDAO.getUngroupedByYAxis(trx, yAxisDef);
            if (ungroupedVarSeries.length > 0) {
                SeriesGroup defaultSeriesGroup = new SeriesGroup();
                defaultSeriesGroup.setType(yAxisDef.getDefaultRendererType());
                defaultSeriesGroup.setYAxis(yAxisDef);
                VarSeries2D[] varSeries2DArray = ungroupedVarSeries;
                int n7 = ungroupedVarSeries.length;
                int n8 = 0;
                while (n8 < n7) {
                    VarSeries2D varSeries = varSeries2DArray[n8];
                    defaultSeriesGroup.getSeries().add(varSeries);
                    varSeries.setSeriesGroup(defaultSeriesGroup);
                    if (varSeries.getVariable() != null) {
                        varSeries.setVariable(VariableDAO.get(trx, varSeries.getVariable().getId()));
                    }
                    ++n8;
                }
                yAxisDef.getSeriesGroups().add(defaultSeriesGroup);
            }
            ++n2;
        }
        return chart;
    }

    public static Chart2D[] getUngrouped(Transaction trx) {
        return (Chart2D[])Client.getWebTarget().path(String.format("%s/get_ungrouped/trx=%s", PREFIX, trx)).request().get(Chart2D[].class);
    }

    public static Chart2D[] getByGroup(Transaction trx, ChartGroup group) {
        return (Chart2D[])Client.getWebTarget().path(String.format("%s/get_by_group/trx=%s&group_id=%d", PREFIX, trx, group.getId())).request().get(Chart2D[].class);
    }

    public static Chart2D[] findByClass(Transaction trx, StructureClass structureClass) {
        return (Chart2D[])Client.getWebTarget().path(String.format("%s/find_by_class/trx=%s&class_id=%d", PREFIX, trx, structureClass.getId())).request().get(Chart2D[].class);
    }

    public static int saveOrUpdate(Transaction trx, Chart2D chart) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)chart));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

