/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts;

import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class SankeyNodeDAO {
    private static final String PREFIX = "charts/sankey_node";

    public static SankeyNode get(Transaction trx, int id) {
        return (SankeyNode)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(SankeyNode.class);
    }

    public static SankeyNode[] getAllNodes(Transaction trx, SankeyChart chart) {
        return (SankeyNode[])Client.getWebTarget().path(String.format("%s/get_by_chart/trx=%s&chart_id=%d", PREFIX, trx, chart.getId())).request().get(SankeyNode[].class);
    }

    public static SankeyNode[] getChildNodes(Transaction trx, SankeyNode node) {
        return (SankeyNode[])Client.getWebTarget().path(String.format("%s/get_by_parent_node/trx=%s&node_id=%d", PREFIX, trx, node.getId())).request().get(SankeyNode[].class);
    }

    public static SankeyNode[] getRootNodes(Transaction trx, SankeyChart chart) {
        return (SankeyNode[])Client.getWebTarget().path(String.format("%s/get_root_nodes/trx=%s&chart_id=%d", PREFIX, trx, chart.getId())).request().get(SankeyNode[].class);
    }

    public static int saveOrUpdate(Transaction trx, SankeyNode node) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)node));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

