/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.charts.viewprefs;

import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.ewms.core.variable.VariableInstance;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class SeriesViewPrefsDAO {
    private static final String PREFIX = "charts/chart2d/var_series_view_prefs";

    public static Series2DViewPrefs get(Transaction trx, Chart2DViewPrefs chartViewPrefs, VarSeries2D varSeries, VariableInstance varInstance, TimelinePhase phase) {
        if (chartViewPrefs.getId() == null) {
            return null;
        }
        return (Series2DViewPrefs)Client.getWebTarget().path(String.format("%s/get/trx=%s&cvp_id=%d&var_series_id=%d&var_inst_id=%d&phase_id=%s", PREFIX, trx, chartViewPrefs.getId(), varSeries.getId(), varInstance.getId(), phase != null ? phase.getId().toString() : "")).request().get(Series2DViewPrefs.class);
    }

    public static Series2DViewPrefs getOrDefault(Transaction trx, Chart2DViewPrefs chartViewPrefs, VarSeries2D varSeries, VariableInstance varInstance, TimelinePhase phase) {
        Series2DViewPrefs prefs = SeriesViewPrefsDAO.get(trx, chartViewPrefs, varSeries, varInstance, phase);
        if (prefs == null) {
            prefs = new Series2DViewPrefs(chartViewPrefs, varSeries, varInstance, null);
        }
        prefs.setChartViewPrefs(chartViewPrefs);
        prefs.setSeries(varSeries);
        prefs.setVariableInstance(varInstance);
        prefs.setTimelinePhase(phase);
        return prefs;
    }

    public static int saveOrUpdate(Transaction trx, Series2DViewPrefs seriesViewPrefs) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)seriesViewPrefs));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

