/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.datasource;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.client.bundle.Activator;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.handlers.ImportSignalIdsRequest;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.eclipse.fx.core.log.Logger;

public class DataSourceDAO {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataSourceDAO.class.getName());
    private static final String PREFIX = "datasource/source";

    public static DataSource get(Transaction trx, int id) {
        DataSource ret = (DataSource)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(DataSource.class);
        if (ret == null) {
            return null;
        }
        ret.setConnected(DataSourceDAO.getClientState(id));
        return ret;
    }

    public static DataSource[] getAll(Transaction trx) {
        DataSource[] ret = (DataSource[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(DataSource[].class);
        if (ret == null) {
            return null;
        }
        DataSource[] dataSourceArray = ret;
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            DataSource ds = dataSourceArray[n2];
            ds.setConnected(DataSourceDAO.getClientState(ds.getId()));
            ++n2;
        }
        return ret;
    }

    public static int saveOrUpdate(Transaction trx, DataSource dataSource) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)dataSource));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static DataClientState getClientState(int dataSourceId) {
        try {
            String url = String.format("%s/client/get_state/id=%d", PREFIX, dataSourceId);
            return (DataClientState)Client.getWebTarget().path(url).request().get(DataClientState.class);
        }
        catch (Exception exc) {
            logger.error("Error reading client state", (Throwable)exc);
            return null;
        }
    }

    public static SignalId[] getRootSignals(int dataSourceId) throws DAOOperationException {
        String url = String.format("%s/client/root_signals/get/id=%d", PREFIX, dataSourceId);
        Response response = Client.getWebTarget().path(url).request().get();
        try {
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (SignalId[])response.readEntity(SignalId[].class);
            }
            OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
            throw new DAOOperationException(result);
        }
        catch (DAOOperationException daoExc) {
            throw daoExc;
        }
        catch (Exception exc) {
            throw new DAOOperationException(new OperationResult(ResultType.UnexprectedError, exc.getMessage()));
        }
    }

    public static SignalId[] getChildSignals(int dataSourceId, SignalId parentSignalId) {
        try {
            String url = String.format("%s/client/child_signals/get/id=%d", PREFIX, dataSourceId);
            Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)parentSignalId));
            return (SignalId[])response.readEntity(SignalId[].class);
        }
        catch (Exception exc) {
            logger.error(String.format("Error reading client leaf signals from Node %s", parentSignalId.toString()), (Throwable)exc);
            return null;
        }
    }

    public static SignalId loadSignalAttributes(int dataSourceId, SignalId parentSignalId) {
        try {
            String url = String.format("%s/client/load_signal_attributes/get/id=%d", PREFIX, dataSourceId);
            Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)parentSignalId));
            return (SignalId)response.readEntity(SignalId.class);
        }
        catch (Exception exc) {
            logger.error(String.format("Error reading Attributes from Node %s", parentSignalId.toString()), (Throwable)exc);
            return null;
        }
    }

    public static SignalDataValue getCurrentValue(int dataSourceId, SignalId signalId) {
        try {
            String url = String.format("%s/client/value/get/id=%d", PREFIX, dataSourceId);
            Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)signalId));
            SignalDataValue dv = (SignalDataValue)response.readEntity(SignalDataValue.class);
            return dv;
        }
        catch (Exception exc) {
            logger.error(String.format("Error reading client leaf signals from Node %s", signalId), (Throwable)exc);
            return null;
        }
    }

    public static OperationResult connect(int dataSourceId) throws DAOOperationException {
        String url = String.format("%s/client/connect/id=%d", PREFIX, dataSourceId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        return result;
    }

    public static void disconnect(int dataSourceId) throws DAOOperationException {
        String url = String.format("%s/client/disconnect/id=%d", PREFIX, dataSourceId);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void importSignalIds(ImportSignalIdsRequest request) throws DAOOperationException {
        String url = String.format("%s/client/import_signal_ids", PREFIX);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().post(Entity.json((Object)request)).readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

