/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.events;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.events.EventActionJobDescriptor;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class EventActionDAO {
    private static final String PREFIX = "events/event_action";

    public static EventAction get(Transaction trx, int id) {
        return (EventAction)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(EventAction.class);
    }

    public static EventAction[] getByEvent(Transaction trx, Event event) {
        return (EventAction[])Client.getWebTarget().path(String.format("%s/get_by_event/trx=%s&event_id=%d", PREFIX, trx, event.getId())).request().get(EventAction[].class);
    }

    public static EventActionJobDescriptor[] getJobDescriptors() {
        return (EventActionJobDescriptor[])Client.getWebTarget().path(String.format("%s/get_job_descriptors", PREFIX)).request().get(EventActionJobDescriptor[].class);
    }

    public static int saveOrUpdate(Transaction trx, EventAction event) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)event));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

