/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.export;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.export.ExportDataRequest;
import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ExportDataProfileDAO {
    private static final String PREFIX = "export/data_profile";

    public static ExportDataProfile get(Transaction trx, int id) {
        return (ExportDataProfile)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ExportDataProfile.class);
    }

    public static ExportDataProfile[] getAll(Transaction trx) {
        return (ExportDataProfile[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(ExportDataProfile[].class);
    }

    public static ExportDataWriterDescriptor[] getAvailableExportDataWriters() {
        return (ExportDataWriterDescriptor[])Client.getWebTarget().path(String.format("%s/get_available_data_writers", PREFIX)).request().get(ExportDataWriterDescriptor[].class);
    }

    public static void exportData(ExportDataRequest request) throws DAOOperationException {
        String url = String.format("%s/export_data", PREFIX);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)request));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static int saveOrUpdate(Transaction trx, ExportDataProfile profile) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)profile));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

