/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.graphs;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.graph.GraphChart;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class GraphDefinitionDAO {
    private static final String PREFIX = "graphs/graph";

    public static GraphChart get(Transaction trx, int id) {
        return (GraphChart)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(GraphChart.class);
    }

    public static GraphChart[] getAll(Transaction trx) {
        return (GraphChart[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(GraphChart[].class);
    }

    public static int saveOrUpdate(Transaction trx, GraphChart vp) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)vp));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

