/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.measurements;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.value.VarInstanceMeasuredValuesMap;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import java.time.Instant;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class MeasurementsDAO {
    private static final String PREFIX = "measurements";

    public static void appendMeasuredValues(VarInstanceValuesCollectionMap values, boolean syncExec) throws DAOOperationException {
        String path = String.format("%s/append/values_collection_map/sync_exec=%s", PREFIX, Boolean.toString(syncExec));
        Response response = Client.getWebTarget().path(path).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void appendMeasuredValues(VarInstanceMeasuredValuesMap values, boolean syncExec) throws DAOOperationException {
        String path = String.format("%s/append/measured_values_map/sync_exec=%s", PREFIX, Boolean.toString(syncExec));
        Response response = Client.getWebTarget().path(path).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void appendMeasuredValues(VarInstanceMeasuredValuesMap values) throws DAOOperationException {
        MeasurementsDAO.appendMeasuredValues(values, false);
    }

    public static void importMeasuredValues(VarInstanceValuesCollectionMap values) throws DAOOperationException {
        Response response = Client.getWebTarget().path(String.format("%s/import/values_collection_map", PREFIX)).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void importMeasuredValues(VarInstanceMeasuredValuesMap values) throws DAOOperationException {
        Response response = Client.getWebTarget().path(String.format("%s/import/measured_values_map", PREFIX)).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void copyMeasuredValues(StructureObject srcObject, StructureObject dstObject, Instant from, Instant to) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/copy_measured_values/src_object_id=%d&dst_object_id=%d&from=%s&to=%s", PREFIX, srcObject.getId(), dstObject.getId(), from != null ? Long.toString(from.toEpochMilli()) : "", to != null ? Long.toString(to.toEpochMilli()) : "")).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void importPredictedMeasuredValues(VarInstanceValuesCollectionMap values) throws DAOOperationException {
        Response response = Client.getWebTarget().path(String.format("%s/import/predicted_values_collection_map", PREFIX)).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void importPredictedMeasuredValues(VarInstanceMeasuredValuesMap values) throws DAOOperationException {
        Response response = Client.getWebTarget().path(String.format("%s/import/predicted_measured_values_map", PREFIX)).request().post(Entity.json((Object)values));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

