/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.notes;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureObject;
import java.time.Instant;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class NoteDAO {
    private static final String PREFIX = "notes/note";

    public static Note get(Transaction trx, int id) {
        return (Note)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Note.class);
    }

    public static Note[] getByStructureObject(Transaction trx, RawValuesViewType viewType, Integer viewIndex, StructureObject structureObject, Instant from, Instant to) {
        return NoteDAO.findByStructureObject(trx, viewType, viewIndex, structureObject, from, to, SearchPolicy.This, null);
    }

    public static Note[] findByStructureObject(Transaction trx, RawValuesViewType viewType, Integer viewIndex, StructureObject structureObject, Instant from, Instant to, SearchPolicy searchPolicy, NoteType filter) {
        return (Note[])Client.getWebTarget().path(String.format("%s/find_by_object/trx=%s&view_type=%s&view_index=%s&object_id=%d&from_ts=%s&to_ts=%s&search_policy=%s&filter=%s", PREFIX, trx, viewType.name(), viewIndex != null ? viewIndex : "", structureObject.getId(), from != null ? Long.toString(from.toEpochMilli()) : "", to != null ? Long.toString(to.toEpochMilli()) : "", searchPolicy.name(), filter != null ? filter.name() : "")).request().get(Note[].class);
    }

    public static int saveOrUpdate(Transaction trx, Note note) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)note));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

