/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.preferences;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.server.ServerState;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;

public class ServerDAO {
    private static final String PREFIX = "server";

    public static TimeRange getGlobalViewTimeRange() {
        return ServerDAO.getValuesTimeRange(RawValuesViewType.GlobalView, null);
    }

    public static TimeRange getValuesTimeRange(RawValuesViewType type, Integer customViewIndex) {
        return (TimeRange)Client.getWebTarget().path(String.format("%s/get_values_view_timerange/view_type=%s&view_index=%s", PREFIX, type.name(), customViewIndex != null ? customViewIndex : "")).request().get(TimeRange.class);
    }

    public static TimeRange getGlobalViewArchiveTimeRange() {
        return ServerDAO.getArchiveTimeRange(RawValuesViewType.GlobalView, null);
    }

    public static TimeRange getRealtimeViewArchiveTimeRange() {
        return ServerDAO.getArchiveTimeRange(RawValuesViewType.RealtimeView, null);
    }

    public static TimeRange getArchiveTimeRange(RawValuesViewType type, Integer customViewIndex) {
        return (TimeRange)Client.getWebTarget().path(String.format("%s/get_values_view_archive_timerange/view_type=%s&view_index=%s", PREFIX, type.name(), customViewIndex != null ? customViewIndex : "")).request().get(TimeRange.class);
    }

    public static void setGlobalViewCoreDataStart(long newStart) throws DAOOperationException {
        String url = String.format("%s/set_globalview_core_data_start/ts=%d", PREFIX, newStart);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static Raster getGlobalViewRaster() {
        return ServerDAO.getRawValuesViewRaster(RawValuesViewType.GlobalView, null);
    }

    public static Raster getRealtimeViewRaster() {
        return ServerDAO.getRawValuesViewRaster(RawValuesViewType.RealtimeView, null);
    }

    public static Raster getRawValuesViewRaster(RawValuesViewType type, Integer customViewIndex) {
        return (Raster)Client.getWebTarget().path(String.format("%s/get_raw_values_view_raster/view_type=%s&view_index=%s", PREFIX, type.name(), customViewIndex != null ? customViewIndex : "")).request().get(Raster.class);
    }

    public static void restartServer() throws DAOOperationException {
        String url = String.format("%s/restart_server", PREFIX);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static void shutdownServer() throws DAOOperationException {
        String url = String.format("%s/shutdown_server", PREFIX);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static ServerState getServerState() throws DAOOperationException {
        String url = String.format("%s/server_state", PREFIX);
        return (ServerState)Client.getWebTarget().path(url).request().get(ServerState.class);
    }

    public static ServerInfo getInfo() {
        String url = String.format("%s/info", PREFIX);
        return (ServerInfo)Client.getWebTarget().path(url).request().get(ServerInfo.class);
    }

    public static String getEOSCoreChangelog() {
        String url = String.format("%s/get_eos_core_changelog", PREFIX);
        return (String)Client.getWebTarget().path(url).request().get(String.class);
    }

    public static String getChangelog(String componentId) {
        String url = String.format("%s/get_component_changelog/component_id=%s", PREFIX, componentId);
        return (String)Client.getWebTarget().path(url).request().get(String.class);
    }
}

