/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.rawvalues;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.rawvalues.RawValuesViewCreateRequest;
import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewPrepareCreateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewStateResponse;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import java.time.Instant;
import javax.ws.rs.client.Entity;

public class RawValuesViewDAO {
    private static final String PREFIX = "rawvalues/view";

    public static RawValuesViewPrepareCreateResponse prepareCreateView(RawValuesViewCreateRequest createRequest) {
        String url = String.format("%s/prepare", PREFIX);
        return (RawValuesViewPrepareCreateResponse)Client.getWebTarget().path(url).request().post(Entity.json((Object)createRequest)).readEntity(RawValuesViewPrepareCreateResponse.class);
    }

    public static int createView(RawValuesViewCreateRequest createRequest) throws DAOOperationException {
        String url = String.format("%s/create", PREFIX);
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().post(Entity.json((Object)createRequest)).readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static RawValuesViewDescriptor getView(RawValuesViewType type, Integer viewIndex) {
        String url = String.format("%s/get/view_type=%s&view_index=%s", PREFIX, type.name(), viewIndex != null ? Integer.toString(viewIndex) : "");
        return (RawValuesViewDescriptor)Client.getWebTarget().path(url).request().get(RawValuesViewDescriptor.class);
    }

    public static void remove(int customViewIndex) throws DAOOperationException {
        String url = String.format("%s/remove/custom_view_index=%s", PREFIX, Integer.toString(customViewIndex));
        OperationResult result = (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static RawValuesViewStateResponse getViewState(RawValuesViewType type, Integer viewIndex) {
        String url = String.format("%s/get_state/view_type=%s&view_index=%s", PREFIX, type.name(), viewIndex != null ? Integer.toString(viewIndex) : "");
        return (RawValuesViewStateResponse)Client.getWebTarget().path(url).request().get(RawValuesViewStateResponse.class);
    }

    public static RawValuesViewDescriptor[] getViews(RawValuesViewType type) {
        String url = String.format("%s/get/view_type=%s", PREFIX, type.name());
        return (RawValuesViewDescriptor[])Client.getWebTarget().path(url).request().get(RawValuesViewDescriptor[].class);
    }

    public static OperationResult synchronizeArchivesWithRAWDB(Instant from, Instant to) {
        String url = String.format("%s/synchronize_archives_with_raw_db/from=%d&to=%d", PREFIX, from.toEpochMilli(), to.toEpochMilli());
        return (OperationResult)Client.getWebTarget().path(url).request().get(OperationResult.class);
    }
}

