/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.report;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class TableReportConfigDAO {
    private static final String PREFIX = "report/table_config";

    public static TableReportConfig get(Transaction trx, int id) {
        return (TableReportConfig)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(TableReportConfig.class);
    }

    public static TableReportConfig[] getByTableReport(Transaction trx, TableReport tableReport) {
        return (TableReportConfig[])Client.getWebTarget().path(String.format("%s/get_by_table_report/trx=%s&table_report_id=%d", PREFIX, trx, tableReport.getId())).request().get(TableReportConfig[].class);
    }

    public static int saveOrUpdate(Transaction trx, TableReportConfig tableReportConfig) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)tableReportConfig));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

