/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.resources;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.resources.RDFolder;
import de.elpro.ewms.core.resources.RDItem;
import de.elpro.ewms.core.resources.ResourceDirectory;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class ResourceDirectoryDAO {
    private static final String PREFIX = "resources/resource_directory";

    public static ResourceDirectory get(Transaction trx, int id) {
        return (ResourceDirectory)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(ResourceDirectory.class);
    }

    public static ResourceDirectory[] getAll(Transaction trx) {
        return (ResourceDirectory[])Client.getWebTarget().path(String.format("%s/get_all/trx=%s", PREFIX, trx)).request().get(ResourceDirectory[].class);
    }

    public static int saveOrUpdate(Transaction trx, ResourceDirectory resourceDirectory) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)resourceDirectory));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }

    public static RDFolder[] getResourceDirectoryFolders(Transaction trx, ResourceDirectory resourceDirectory, String ... path) {
        String pathStr = "";
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            pathStr = String.valueOf(pathStr) + pathItem + "/";
            ++n2;
        }
        return (RDFolder[])Client.getWebTarget().path(String.format("%s/get_folders/trx=%s&id=%d&path=%s", PREFIX, trx, resourceDirectory.getId(), pathStr)).request().get(RDFolder[].class);
    }

    public static RDItem[] getResourceDirectoryItems(Transaction trx, ResourceDirectory resourceDirectory, String ... path) {
        String pathStr = "";
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            pathStr = String.valueOf(pathStr) + pathItem + "/";
            ++n2;
        }
        return (RDItem[])Client.getWebTarget().path(String.format("%s/get_items/trx=%s&id=%d&path=%s", PREFIX, trx, resourceDirectory.getId(), pathStr)).request().get(RDItem[].class);
    }

    public static Boolean checkFileExists(Transaction trx, ResourceDirectory resourceDirectory, String fileName, String ... path) {
        String pathStr = "";
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            pathStr = String.valueOf(pathStr) + pathItem + "/";
            ++n2;
        }
        return (Boolean)Client.getWebTarget().path(String.format("%s/check_file_exists/trx=%s&id=%d&file_name=%s&path=%s", PREFIX, trx, resourceDirectory.getId(), fileName, pathStr)).request().get(Boolean.class);
    }

    public static OperationResult storeFile(byte[] data, Transaction trx, ResourceDirectory resourceDirectory, String fileName, String ... path) {
        String pathStr = "";
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathItem = stringArray[n2];
            pathStr = String.valueOf(pathStr) + pathItem + "/";
            ++n2;
        }
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/store_file/trx=%s&id=%d&file_name=%s&path=%s", PREFIX, trx, resourceDirectory.getId(), fileName, pathStr)).request().post(Entity.json((Object)data)).readEntity(OperationResult.class);
        return result;
    }
}

