/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.structure;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public class PropertyDAO {
    private static final String PREFIX = "structure/property";

    public static Property get(Transaction trx, Integer id) {
        return (Property)Client.getWebTarget().path(String.format("%s/get/trx=%s&id=%d", PREFIX, trx, id)).request().get(Property.class);
    }

    public static Property get(Transaction trx, String propertyGroupKey, String propertyKey) {
        return (Property)Client.getWebTarget().path(String.format("%s/get/trx=%s&group_key=%s&property_key=%s", PREFIX, trx, propertyGroupKey, propertyKey)).request().get(Property.class);
    }

    public static Property[] get(Transaction trx, StructureClass structureClass, String propertyTypeId) {
        return (Property[])Client.getWebTarget().path(String.format("%s/get/trx=%s&structure_class_id=%d&property_type_id=%s", PREFIX, trx, structureClass.getId(), propertyTypeId)).request().get(Property[].class);
    }

    public static Property[] get(Transaction trx, PropertyGroup propertyGroup) {
        return PropertyDAO.get(trx, propertyGroup.getKey());
    }

    public static Property[] get(Transaction trx, String groupKey) {
        return (Property[])Client.getWebTarget().path(String.format("%s/get/trx=%s&group_key=%s", PREFIX, trx, groupKey)).request().get(Property[].class);
    }

    public static int saveOrUpdate(Transaction trx, Property property) throws DAOOperationException {
        String url = String.format("%s/save_or_update/trx=%s", PREFIX, trx);
        Response response = Client.getWebTarget().path(url).request().post(Entity.json((Object)property));
        OperationResult result = (OperationResult)response.readEntity(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
        return (Integer)result.getObjectId();
    }

    public static void delete(Transaction trx, int id) throws DAOOperationException {
        OperationResult result = (OperationResult)Client.getWebTarget().path(String.format("%s/delete/trx=%s&id=%d", PREFIX, trx, id)).request().get(OperationResult.class);
        if (result.getType() != ResultType.Success) {
            throw new DAOOperationException(result);
        }
    }
}

