/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.client.structure;

import de.elpro.ewms.core.client.Client;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureClassRole;
import de.elpro.ewms.core.structure.StructureObject;

public class StructureClassRoleDAO {
    public static final String PREFIX = "structure/class/role";

    public static IStructureClassRole get(String id) {
        return (IStructureClassRole)Client.getWebTarget().path(String.format("%s/get/id=%s", PREFIX, id)).request().get(StructureClassRole.class);
    }

    public static IStructureClassRole[] getAll() {
        return (IStructureClassRole[])Client.getWebTarget().path(String.format("%s/get_all", PREFIX)).request().get(StructureClassRole[].class);
    }

    public static StructureClass[] getAllClassesByRole(Transaction trx, String classRoleId) {
        return (StructureClass[])Client.getWebTarget().path(String.format("%s/get_all_classes/trx=%d&role_id=%s", PREFIX, trx.getId(), classRoleId)).request().get(StructureClass[].class);
    }

    public static StructureObject[] getAllObjectsByRole(Transaction trx, String classRoleId) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_all_objects/trx=%d&role_id=%s", PREFIX, trx.getId(), classRoleId)).request().get(StructureObject[].class);
    }

    public static StructureObject[] getAllObjectsByRole(Transaction trx, IStructureClassRole role) {
        return StructureClassRoleDAO.getAllObjectsByRole(trx, role.getId());
    }

    public static StructureObject[] getChildObjectsByRole(Transaction trx, String classRoleId, StructureObject parentObject) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_child_objects/trx=%d&role_id=%s&obj_id=%d", PREFIX, trx.getId(), classRoleId, parentObject.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] getChildObjectsByRole(Transaction trx, IStructureClassRole role, StructureObject parentObject) {
        return StructureClassRoleDAO.getChildObjectsByRole(trx, role.getId(), parentObject);
    }

    public static StructureObject[] getParentObjectsByRole(Transaction trx, String classRoleId, StructureObject childObject) {
        return (StructureObject[])Client.getWebTarget().path(String.format("%s/get_parent_objects/trx=%d&role_id=%s&obj_id=%d", PREFIX, trx.getId(), classRoleId, childObject.getId())).request().get(StructureObject[].class);
    }

    public static StructureObject[] getParentObjectsByRole(Transaction trx, IStructureClassRole role, StructureObject childObject) {
        return StructureClassRoleDAO.getParentObjectsByRole(trx, role.getId(), childObject);
    }
}

